<?php

// http://example.com/home/wp-content/themes/atahualpa
$url_base = get_bloginfo('template_directory');

// http://example.com/home
$wordpress_base = get_bloginfo('url');

// /wp-content/themes/atahualpa/
$template_path = str_replace( $wordpress_base, '', $url_base) . '/';

// example.com/home
$server_name_incl_wp_dir = str_replace("http://", "", $wordpress_base);

// /home
$wordpress_dir = str_replace($_SERVER['SERVER_NAME'], '', $server_name_incl_wp_dir);

// /home/wp-content/themes/atahualpa/
$css_img_path = $wordpress_dir . $template_path;

$bfa_ata_widget_areas = get_option('bfa_widget_areas');
if (is_array($bfa_ata_widget_areas)) {
	foreach ($bfa_ata_widget_areas as $widget_area) {
		$widget_form_string .= '
		<input type="checkbox" name="delete_widget_areas" id="' . 
		$widget_area['name'] . '" value="' . $widget_area['name'] . '" /><label class="widget_area_label" for="' . $widget_area['name'] . 
		'">' . $widget_area['name'] . '</label><br />';
	}
}

// different options text for WP and WPMU, because image upload works differently
$header_image_text_wp = "To add your own header image(s), upload one or several
images with any file names <code>anything.[jpg|gif|png]</code> i.e.
<code>hfk7wdfw8.gif</code>, <code>IMAGE_1475.jpg</code>, <code>bla.png</code>
to ". $template_path ."images/header/ through FTP. You will need a
\"FTP Client\" software such as <a href=\"http://filezilla-project.org/download.php\">
Filezilla</a> (free), the Firefox extension
<a href=\"https://addons.mozilla.org/de/firefox/addon/684\">FireFTP</a> (free)
or <a href=\"http://www.smartftp.com/download/\">SmartFTP</a> ($36.95).";

$header_image_text_wpmu = "To upload your own header images, you'll need to prepare your header image(s) 
on your harddrive first. Rename your header images to <code>atahualpa_header_X.[jpg|gif|png|bmp]</code> 
(Example: <code>atahualpa_header_1.jpg</code>, <code>atahualpa_header_3.png</code>, 
<code>atahualpa_header_182.gif</code>) and then, upload them to your WordPress site through the WordPress Editor</strong>. 
<br /><br />There may be no \"upload\" tab in the admin area though. In that case, start as if you were going to 
add an image to a post: Go to Admin -> Manage -> Posts, and click on the title of an existing post to open the editor. 
Click on the \"Add Media\" link, and in the next window click on the \"Choose files to upload\" button. 
That will open a window on your local computer where you can find and select the header image 
(which you've already renamed as described before) on your local harddrive. Select \"Full Size\" and, 
do NOT click on \"Insert into Post\" but click on \"Save all changes\" instead. Now reload your Homepage 
and the new header image should appear. If you want more than one header image (to have them rotate) simply 
repeat all these steps. Atahualpa will autmatically recognize all images that are named 
<code>atahualpa_header_X.[jpg|png|gif]</code>. If there's only one image, then it'll be your single, 
\"static\" header image. If there's more than one image, then Atahualpa will rotate them with every pageview.";

$logo_icon_text_wp = "To show your own graphic, upload an image to <strong>". $template_path ."images/</strong>
and put the file name of the image into this field. <br /><br /><strong>Example:</strong><br /><code>myownlogo.gif</code>
<br /><br />Make sure you have <strong>no spaces</strong> or exotic characters in the image file name. 
Your Windows or Mac Computer may display them but the hosting server probably won't. The image file can 
have a .gif, .jpg, .jpeg, .png or .bmp extension.";

$logo_icon_text_wpmu = "To show your own graphic, upload an image through the WordPress Editor. 
There may be no \"upload\" tab in your WordPress version. To upload the image start as if you were going to 
add an image to a post: Go to Admin -> Manage -> Posts, and click on the title of an existing post to open 
the editor. Click on the \"Add Media\" link, and in the next window click on the \"Choose files to upload\" button. 
That will open a window on your local computer where you can select the image on your local harddrive. 
After you've selected the image, choose \"Full Size\" and, instead of clicking on \"Insert into Post\", 
click on \"Save all changes\". Then put the file name of your image into this field, i.e. <code>my-new-logo.jpg</code> 
and click \"Save changes\" at the bottom fo this page. Now reload your Homepage and your new logo should appear 
instead of the default one.<br /><br />Make sure you have no spaces or exotic characters in the image file name. 
Your Windows or Mac Computer may display them but the hosting server probably won't. The image file can have 
a .gif, .jpg, .jpeg, .png or .bmp extension.";

if (defined('ABSPATH')) { 
	if (file_exists(ABSPATH."/wpmu-settings.php")) {
		$header_image_text = $header_image_text_wpmu; 
		$logo_icon_text = $logo_icon_text_wpmu; 
	} 
} else { 
	$header_image_text = $header_image_text_wp; 
	$logo_icon_text = $logo_icon_text_wp;
}

// different options text for different WP versions
if( function_exists('wp_list_comments') ) {
	// WP 2.7+
	$go_to_pages = "go to Site Admin -> Pages -> Edit";
	$go_to_cats = "go to Site Admin -> Posts -> Categories";
	$path_to_widgets = "Appearance";
} else {
	// WP 2.6 and older
	$go_to_pages = "go to Site Admin -> Manage -> Pages";
	$go_to_cats = "go to Site Admin -> Manage -> Categories";
	$path_to_widgets = "Design (\"Presentation\" in WP 2.3 and older)";
}

// array of theme options starts here. Set the category of the first option of every new option category to "category_name", except for the very first option, which will be hard coded in functions.php
$themename = "Atahualpa";
$shortname = "bfa_ata";
$options1 = array(

    array(    "name" => "Atahualpaをご利用下さいましてありがとうございます",
    	    "category" => "start-here",
            "id" => $shortname."_start_here",
            "type" => "info",
			"lastoption" => "yes", 
            "info" => "<br />AtahualpaはGPLに基づいてリリースされている<strong>成熟した, ブラウザセーフの WordPress/PHP/CSS フレームワーク</strong>です.<br />
          <h3>サポート</h3>
			サポート, Atahualpaに関する議論, 言語ファイルの入手などについては<a href=\"http://forum.bytesforall.com/\">Bytes For All Forum</a>を参照下さい.<br />
			<h3>寄付のお願い</h3>Atahualpaの開発のために膨大な時間が注ぎ込まれてきました. <a href=\"http://wordpress.bytesforall.com/\">
			wordpress.bytesforall.com</a>と<a href=\"http://forum.bytesforall.com/\">forum.bytesforall.com</a>の\"Donate\"リンクを参照お願いします. 
			forum.bytesforall.comの<a href=\"http://forum.bytesforall.com/awc_ds.php?do=donation\">donating member</a>になると,
			開発者やモデレータから優先的に連絡を受けられるなどの<strong>追加特典</strong>があります. フォーラム
			を購読してから寄付を行うと,寄付とフォーラムのユーザ名とが関連付けられますので, そのようにするのがお勧めです. <br />
			<h3>CSSを利用したカスタマイズ</h3>柔軟性を高くすることを目的とし, 多くのサイトエレメントはカラーピッカーとセレクトメニューではなく, 生のCSSで
			スタイルを設定することができるようになっています. しかし, 構える必要はありません. レイアウトやブラウザ間の互換性といった難しい問題についてはすべて
			Atahualpaが面倒を見ますので, あなたが設定しなければならないのは, 枠線や色, フォントやパディング, マージンなどのCSSの楽しい部分だけになります.
			<h3>CSSの利用ガイド</h3><ul><li>AtahualpaのCSSは, css.phpで動的に生成されます. css.phpは直接変更するべきではありません. なぜならば, Atahualpa
			のバージョンアップがあるたびに, 同じ変更を行う必要が発生するからです. そうではなく, テーマオプションに含まれる多数のテキストエリアの一つを利用
			して, CSSの特定箇所のレイアウトを設定するようにしてください.</li>
			<li>テーマオプション経由でCSSのカスタマイズを行う場合, ブラケットに囲まれた赤色の部分のみを編集します: 
			<code>selector {<i>property:value; property2:value2;</i>}</code></li><li>説明や例, デフォルトの設定などでセミコロン<code>;</code>で閉じないように
			と指定されている場合を除いて, すべてのproperty:valueのペアは, セミコロン<code>;</code>で閉じてください.
			</li><li>まったく新しいスタイル(セレクタやブラケットを含む)を追加したい場合は, 
			<a href=\"javascript: myflowers.expandit('html-inserts-tab')\">HTML/CSSの挿入</a> -> CSSの挿入からメニュータブに追加してください.</li>
			<li>CSSについてより詳しく知りたければ,<a href=\"http://www.w3schools.com/css/css_syntax.asp\">W3 Schools</a>を参照してください.</li></ul>
			<h3>プラグイン</h3><a href=\"http://wordpress.org/extend/plugins/\">plugins</a>を利用することで, 更にサイトの価値を高めることができます. 
			Atahualpaはほぼんどのプラグインと組み合わせることができるはずです. 以下のプラグインについては, プラグアンドプレイでサポートされます: 
			<a href=\"http://txfx.net/code/wordpress/subscribe-to-comments/\">Subscribe to Comments</a>, 
			<a href=\"http://www.keyvan.net/code/paged-comments/\">Paged Comments</a>, 
			<a href=\"http://aboutme.lmbbox.com/lmbbox-plugins/lmbbox-comment-quicktags/\">LMB Box Comment Quicktags</a>,
			<a href=\"http://lesterchan.net/portfolio/programming/php/\">WP-PageNavi</a>, 
			<a href=\"http://lesterchan.net/portfolio/programming/php/\">WP-Email</a>, 
			<a href=\"http://lesterchan.net/portfolio/programming/php/\">WP-Print</a>, 
			<a href=\"http://lesterchan.net/portfolio/programming/php/\">WP-PostViews</a>, 
			<a href=\"http://wordpress.org/extend/plugins/sociable/\">Sociable</a>. また, 
			<a href=\"http://wordpress.org/extend/plugins/wp-super-cache/\">WP Super Cache</a>, 
			<a href=\"http://mnm.uib.es/gallir/wp-cache-2/\">WP Cache 2</a>, 
			<a href=\"http://wordpress.org/extend/plugins/wp-syntax/\">WP-Syntax</a>についてもテスト済みです. 
			Atahualpaは自動的に12の人気SEOプラグイン(All-in-one-SEOとHeadspace2を含む)を認識し, 衝突を回避するために自分自身のSEO機能を無効化します.<br />
			"),

// New category: seo

    array(    "name" => "Bytes For AllのSEOオプションの利用",
    	    "category" => "seo",
			"switch" => "yes",
            "id" => $shortname."_use_bfa_seo",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "\"All-in-one-SEO\"や何らかの手段でメタタグを扱うプラグインなど, <strong>他のSEOプラグインを利用している場合は, 
			\"No\"のままにしておいてください.</strong> SEOプラグインとAtahualpaのSEO機能の両方が有効化されると, あなたの
			サイトのメタタグに混乱をきたし, 結果的に検索エンジンのランクに悪影響を与える可能性があります. 
			<br /><br />ここを\"No\"のままにした場合, 以降のSEOオプション(最後の\"Nofollow RSS...\"を除く)
			は実質無効となるため, 無視しても問題ありません. <br /><br /><em>ノート: もしここを\"Yes\"に設定したとしても,
			Atahualpaが他のSEOプラグインが有効化されていることを検知したら, 以降のSEO機能(\"Nofollow RSS...\"と
			\"Make Post Titles H1\"を除く)は有効化されません.</em>"),

    array(    "name" => "ホームページのMeta Descriptionタグ",
    	    "category" => "seo",
            "id" => $shortname."_homepage_meta_description",
            "std" => "",
            "type" => "textarea-large",
			"escape" => "yes", 
            "info" => "1-3センテンス, 合計20-30ワードで入力してください. ホームページの
			Meta Descriptionタグ(のみ)で利用されます. 空欄のままの場合, ホームページの
			Meta Descriptionには何も追加されません.<br /><br />HTML: 利用不可<br />
			単一引用符と二重引用符: 利用可能"),    

    array(    "name" => "ホームページのMeta Keywordsタグ",
    	    "category" => "seo",
            "id" => $shortname."_homepage_meta_keywords",
            "std" => "",
            "type" => "textarea-large",
			"escape" => "yes", 
            "info" => "5-30の単語かフレーズを, コンマ区切りで入力します. ホームページのMeta Keywordsタグ(のみ)
			で利用されます. 空欄のままの場合, ホームページのMeta Keywordsタグには何も追加されません.<br /><br />HTML: 利用不可<br />
			単一引用符と二重引用符: 技術的には可能. ただし, 検索エンジンには嫌われるため, ここで引用符を利用するのは避けるべきでしょう"),

    array(    "name" => "Meta Titleタグの形式",
    	    "category" => "seo",
            "id" => $shortname."_add_blogtitle",
            "type" => "select",
            "std" => "Page Title - Blog Title",
            "options" => array("Page Title - Blog Title", "Blog Title -
            Page Title", "Page Title"),
            "info" => "ブログタイトルをページタイトルの前もしくは後ろに表示する. もしくは, ページタイトルのみを表示する."),

    array(    "name" => "Meta Titleタグセパレータ",
    	    "category" => "seo",
            "id" => $shortname."_title_separator_code",
            "type" => "select",
            "std" => "1",
            "options" => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
            "11", "12", "13"),
            "info" => "ブログタイトルをMeta Tileタグに挿入する選択をした場合(上の選択), 
            ページとブログタイトル(もしくはブログタイトルとページ)との<strong>間に</strong>何を置くかを選択します:<br /><br /> 1<code> &#171;
			</code> &nbsp;  &nbsp;  2<code> &#187; </code> &nbsp;  &nbsp;
            3<code> &#58; </code> &nbsp;  &nbsp; 4<code>&#58; </code> &nbsp;  &nbsp;
            5<code> &#62; </code> &nbsp;  &nbsp;  6<code> &#60; </code> &nbsp; &nbsp;
            7<code> &#45; </code><br /><br />8<span style='background: white; padding: 0 15px'>&lsaquo;</span>  &nbsp;  &nbsp;
            9<span style='background: white; padding: 0 15px'>&#8250;</span> &nbsp;  &nbsp;  
			10<span style='background: white; padding: 0 15px'>&#8226;</span>
            &nbsp; &nbsp;  11<code> &#183; </code> &nbsp; &nbsp;  12<span style='background: white; padding: 0 15px'>
			&#151;</span> &nbsp; &nbsp;  13<code> &#124;&nbsp;</code>"),
 
    array(    "name" => "日付別アーカイブページのインデックス化",
    	    "category" => "seo",
            "id" => $shortname."_archive_noindex",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "日付ベースのアーカイブページに\"noindex, follow\"のメタタグを含めるかどうかを設定します. 
            	目的は, 検索エンジンにあなたのサイトの任意のコンテンツを複数回スパイダーさせないことにあります."),

    array(    "name" => "カテゴリページのインデックス化",
    	    "category" => "seo",
            "id" => $shortname."_cat_noindex",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "カテゴリページに\"noindex, follow\"のメタタグを含めるかどうかを設定します. 
            	目的は前述の通りです."),

    array(    "name" => "タグページのインデックス化",
    	    "category" => "seo",
            "id" => $shortname."_tag_noindex",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "タグページに\"noindex, follow\"のメタタグを含めるかどうかを設定します.
            	目的は前述の通りです."),

    array(    "name" => "投稿/ページのタイトルのH1化",
    	    "category" => "seo",
            "id" => $shortname."_h1_on_single_pages",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "投稿/ページのタイトルをH2からH1に, 単一投稿ページと静的な\"ページ\"のブログのタイトルを
		H1からH2に変更します. <br /><em>これにより, 実際のコンテンツページの重みづけを高くし, ブログ
		タイトルの重み付けが低くなります. 複数の投稿が表示されるページ(ホームページやカテゴリページなど)では, 
		投稿タイトルはH2でブログタイトルはH1のままになります.</em>"),
			
    array(    "name" => "RSS, トラックバック, 管理ページへのリンクのインデックス化",
    	    "category" => "seo",
            "id" => $shortname."_nofollow",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
			"lastoption" => "yes", 
            "info" => "RSS, トラックバック, 管理者ページへのリンクを\"nofollow\"にするかどうかを設定します.
            目的は前述のとおりです."),

// New category: body-font-links

    array(    "name" => "本体のスタイル",
    	    "category" => "body-font-links",
			"switch" => "yes",
            "id" => $shortname."_body_style",
            "std" => "font-family: tahoma, arial, sans-serif;\nfont-size: 0.8em;\ncolor: #000000;\nbackground: #ffffff;",
            "type" => "textarea-large",
            "info" => "他に独自のスタイルが設定されない要素については, ここで指定したスタイルがすべて適用されます. <br /><br />
			<strong>例:</strong> <br /><br />本体の背景イメージの設定:<br /><code>background: 
			url(". $css_img_path ."images/backgr.gif) repeat top left;</code><br />独自のイメージを利用したい場合は, 
			次のパスにアップロードしてください <code>". $css_img_path ."images/</code>
			<br /><br />レイアウトの上下にスペースを確保したい場合:<br />
			<code>padding-top: 20px; padding-bottom: 20px;</code><br /><br />パディングは, レイアウトコンテナのマージンではなく, 
			ここで設定してください(\"レイアウト\"を参照). そちらで設定すると, Internet Explororでは下部のパディングが機能しません."),
			
    array(    "name" => "デフォルトのリンクカラー",
    	    "category" => "body-font-links",
            "id" => $shortname."_link_color",
            "std" => "666666",
            "type" => "text",
            "info" => "16進コードで指定します."),

    array(    "name" => "ポイント時のリンクカラー",
    	    "category" => "body-font-links",
            "id" => $shortname."_link_hover_color",
            "std" => "cc0000",
            "type" => "text",
            "info" => "マウスポインタをリンクに\"合わせた\"時の色です. 16進コードで指定します."),

    array(    "name" => "デフォルトのリンク装飾",
    	    "category" => "body-font-links",
            "id" => $shortname."_link_default_decoration",
            "type" => "select",
            "std" => "none",
            "options" => array("none", "underline"),
            "info" => "デフォルトの状態でリンクにアンダーラインをつけるかどうかを設定します."),

    array(    "name" => "ポイント時のリンク装飾",
    	    "category" => "body-font-links",
            "id" => $shortname."_link_hover_decoration",
            "type" => "select",
            "std" => "underline",
            "options" => array("underline", "none"),
            "info" => "マウスポインタをリンクに合わせた時に, アンダーラインをつけるかどうかを設定します."),

    array(    "name" => "リンクテキストのボールド化",
    	    "category" => "body-font-links",
            "id" => $shortname."_link_weight",
            "type" => "select",
            "std" => "bold",
            "options" => array("bold", "normal"),
			"lastoption" => "yes", 
            "info" => "リンクテキストをボールドにするかどうかを設定します."),

// New category: layout

    array(    "name" => "レイアウトの幅とタイプ(固定 / 可変)",
    	    "category" => "layout",
			"switch" => "yes",
            "id" => $shortname."_layout_width",
            "std" => "99%",
            "type" => "text",
			"size" => "7",
            "info" => "設定するには, <code>%</code> (パーセント)もしくは<code>px</code>
		 が値の後に必要となります. <br /><br /><strong>例</strong><ul><li>
		<code>990px</code> 990ピクセルで固定</li>
		<li><code>92%</code> 可変幅で92%</li><li><code>100%</code>
		可変幅でブラウザの表示幅すべてを利用する</li></ul>"),

    array(    "name" => "最小レイアウト幅",
    	    "category" => "layout",
            "id" => $shortname."_layout_min_width",
            "std" => "",
            "type" => "text",
			"size" => "5",
            "info" => "オプション項目です. 可変幅の場合のみ有効です: 可変幅の場合, 
		最小幅(ピクセル単位)を指定することで, リサイズ時の振る舞いを制限できます.
		<br /><br /><strong>例:</strong> <code>770</code>"),

    array(    "name" => "最大レイアウト幅",
    	    "category" => "layout",
            "id" => $shortname."_layout_max_width",
            "std" => "",
            "type" => "text",
			"size" => "5",
            "info" => "オプション項目です. 可変幅の場合のみ有効です: 可変幅の場合,
		最大幅(ピクセル単位)を指定することで, リサイズ時の振る舞いを制限できます.
		<br /><br /><strong>例:</strong> <code>1250</code>"),

	array(    "name" => "レイアウトコンテナのスタイル",
    	    "category" => "layout",
            "id" => $shortname."_layout_style",
            "std" => "padding: 0;",
            "type" => "textarea-large",
            "info" => "レイアウトコンテナのスタイルを設定します. レイアウトコンテナは, 
		ヘッダー, サイドバー, 中央カラム, フッターといったページ全体を保持します. 
		<ul><li>ここで<code>margin</code>を利用してはいけません. margin-leftと
		margin-rightは, レイアウトコンテナを中奥に置くために必要とされます. 
		実効的にも, 左右にマージンを設定する必要はありません. 左右に余白が必要
		であるならば, レイアウト幅を98%に設定するなどで対処可能です. 
		<code>margin-top</code>もしくは<code>margin-bottom</code>についても, ここで
		設定するのではなく本体でパディングを設定するようにしてください(メニュータブ
		の\"本体, テキスト, リンク\"を参照)</li>
		<li>左右のパディングは, 次のオプションで個別に設定する必要があります.
		ここで設定しても無視されます(0に設定される).</li></ul>
		<strong>例:</strong><br /><br /><code>border: solid 2px #cccccc;
		<br />padding: 10px; /*実質的に上下のパディングにのみ影響を与えます 
		*/</code><br /><code>background: #ffffff;<br />-moz-border-radius:10px;
		<br />-khtml-border-radius: 10px;<br />-webkit-border-radius:10px;<br />
		border-radius: 10px;</code><br /><br />ノート: 角に丸みをつける設定は, 
		Internet Explorerでは機能しません"),

	array(    "name" => "レイアウトコンテナの左右のパディング",
    	    "category" => "layout",
            "id" => $shortname."_layout_style_leftright_padding",
            "std" => "0",
            "type" => "text",
			"size" => "4",
			"lastoption" => "yes", 
            "info" => "レイアウトコンテナで左右にパディングを設定したい場合は,
		ここでピクセル単位の値を指定します. Atahualpaが最小/最大幅の計算に用いるため, 
		この値は個別のスタイルとして必要とします.<strong>例:</strong> <code>20</code>"),

// New category: favicon

	array(    "name" => "Favicon",
    	    "category" => "favicon",
			"switch" => "yes",
            "id" => $shortname."_favicon_file",
            "std" => "new-favicon.ico",
            "type" => "text",
			"size" => "30",
			"lastoption" => "yes", 
            "info" =>  "<img src=\"" . $url_base .
		"/options/images/favicon-locations.gif\" style=\"float: right;
		margin: 0 0 10px 10px;\">" . "<code>fff-sport_soccer.ico</code>のように, 
		Faviconのファイル名をここで設定します. 独自のイメージを利用するには, 
		<code>your-file-name.ico</code>を<strong>/atahualpa3/images/favicon/</strong>
		にアップロードしてください.<br /><br />
		Faviconを利用しないのであれば, 空欄にしておいてください.<br /><br />
		<em>アイコンが表示されない場合: たとえばIE6のように, キャッシュと履歴をクリア
		した上で, 再起動する必要があるブラウザがあります.</em><br />
		<br /><em>ロゴとFaviconとをマッチさせたいのであれば, 下の1-favicon.ico - 44-favicon.icoに
		ついては, 巨大なpngファイル(最大128x128)として
		<a href=\"http://www.icon-king.com/projects/nuvola/\">Nuvola Icon Set</a>で
		公開されています.</em><br /><br />
		<em>ノート: 独自のFaviconを作成した場合: 単純に.gif, .png, .jpgファイルを
		リネームしただけでは, Internet Explorerでは機能しません.<code>.ico</code>
		が実際のファイル形式になります. 32ビットの.png(オプション: 透過背景設定), 
		16x16ピクセルのサイズで作成してから,<a href=\"http://www.towofu.net/soft-e/\">
		@Icon Sushi</a>ようなソフトウェアで<code>.ico</code>ファイルにコンバートして
		ください.</em>
		<img src=\"" . $url_base . "/options/images/favicons.gif\"
		style=\"display: block; margin: 10px;\">"),

// New category: header

    array(    "name" => "ヘッダーエリアの設定",
    	    "category" => "header",
			"switch" => "yes",
            "id" => $shortname."_configure_header",
            "type" => "textarea-large",
            "editable" => "yes",
			"size" => "30",
            "std" => "%pages %logo %bar1 %image %bar2",
            "info" => "10のヘッダーアイテムを利用して, ヘッダーエリアをカスタマイズします:
            <ul><li><code>%pages</code> - \"ページ\"ページの垂直ドロップダウンメニューバー.</li>
		<li><code>%page-center</code> - 上と同じですが, 中央に寄せられます. 
			ノート: このタグに S は含まれません. このタグは%page<strong>S</strong>-center<strong>ではありません.</strong></li>
		<li><code>%page-right</code> - 上と同じですが, 右に寄せられます. 
			ノート: このタグに S は含まれません. このタグは%page<strong>S</strong>-right<strong>ではありません.</strong></li>
		<li><code>%cats</code> - カテゴリの垂直ドロップダウンメニューバー.</li>
		<li><code>%cat-center</code> - 上と同じですが, 中央に寄せられます. 
			ノート: このタグに S は含まれません. このタグは%cat<strong>S</strong>-center<strong>ではありません.</strong></li>
		<li><code>%cat-right</code> - 上と同じですが, 右に寄せられます. 
			ノート: このタグに S は含まれません. このタグは%cat<strong>S</strong>-right<strong>ではありません.</strong></li>
		<li><code>%logo</code> - ロゴアイコン, ブログタイトルと定義, 検索ボックス, RSS/Emailアイコンを含んだロゴエリア</li>
		<li><code>%image</code> - 左右に不透明のオーバレイエリア(オプション)とオーバレイされたブログタイトル, ブログタグライン
			(オプション)を持ったローテートする(もしくは静的な)ヘッダーイメージ.</li>
		<li><code>%bar1</code> - ヘッダーアイテムに挟まれたスペースの上下の装飾に利用される水平バー. 複数回指定できます.</li>
		<li><code>%bar2</code> - 別のスタイルを持ったもう一つの水平バー. 複数回指定できます.</li></ul>
            これらのヘッダーアイテムを利用することで, ページやメニュータブ, <a href=\"javascript: myflowers.expandit('page-menu-bar-tab')\">
            ページメニューバー</a>, <a href=\"javascript: myflowers.expandit('cat-menu-bar-tab')\">カテゴリメニューバー</a>のスタイルを
            設定することができます. <br /><br />このセクションは, ヘッダーエリアの全体的な設定しか行えません.<br /><br />
            表示したいヘッダーアイテムを, 表示したい順番にリストしてください.
            <br /><br />例:<ul><li><code>%image %bar1 %logo %bar1 %pages</code>
            </li><li><code>%pages %image %cats</code></li>
			<li><code>%bar1 %logo %cats %bar2 %pages %bar1</code></li></ul>"),
		
	array(    "name" => "ロゴエリアのスタイル",
    	    "category" => "header",
            "id" => $shortname."_logoarea_style",
            "std" => "",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/logo-area.jpg\" style=\"float: right; 
			margin: 0 0 10px 10px;\">" . "ヘッダーのロゴエリアのスタイルを設定します. ロゴエリアとは ロゴ, ロゴアイコン, 
			ブログタイトル, ブログタグライン, 検索ボックス, RSS/Emailアイコンを保持するコンテナです. 
			ロゴエリアの高さは, そのコンテンツによって決定されます. 更に高さを必要とする場合は, ここで設定してください. 
			設定可能なのは高さ, 枠線, 背景です. このコンテナについてマージンとパディングは設定しないようにしてください. 
			 - これはテーブルなのです.<br /><br />
			<strong>Example:</strong><br /><code>height: 150px;<br />background: #eeeeee;<br />
			border: solid 1px #000000;</code>"),

	array(    "name" => "ロゴイメージを表示",
    	    "category" => "header",
            "id" => $shortname."_logo",
            "type" => "text",
            "std" => "logo.png",
            "info" => "ロゴエリアにロゴイメージを表示するかどうかを設定します. 表示しない場合は空欄にします. テストするには, ここに
			<code>huge-logo.gif</code>と設定した上で, 下にある\"ブログタイトルの表示\"と\"ブログタグラインの
			表示\"とを\"No\"に設定してください. <br /><br />" . $logo_icon_text),

	array(    "name" => "ロゴイメージのスタイル",
    	    "category" => "header",
            "id" => $shortname."_logo_style",
            "std" => "margin: 0 10px 0 0;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/logo-style.gif\" style=\"float: right; 
			margin: 0 0 10px 10px;\">" . "ロゴのスタイルを設定します. 枠線を設定したり, マージンを設定して位置を調整することができます. 
			<br /><br /><strong>例:</strong><br /><br /><code>margin: 30px 30px 30px 30px;</code>"),

    array(    "name" => "ブログタイトルの表示",
    	    "category" => "header",
            "id" => $shortname."_blog_title_show",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "ブログタイトルを表示しないように設定できます. 小さなロゴアイコンとブログタイトルをHTMLで表示させるのではなく, 
			グラフィカルなロゴだけを表示したい場合に設定するといいでしょう. ここを\"No\"に設定したら, ブログタグライン
			も表示しないようにするといいでしょう(下を参照)."),
			
    array(    "name" => "ブログタイトル",
    	    "category" => "header",
            "id" => $shortname."_blog_title_style",
            "std" => "margin: 0;\npadding: 0;\nletter-spacing: -1px;\nline-height: 1.0em;\nfont-family: tahoma, arial, sans-serif;\nfont-size: 240%;",
            "type" => "textarea-large",
            "info" => "ブログタイトルのフォントを設定します. ただし, フォントカラーとフォントウェイトについては, 次のオプションで設定してください."),

    array(    "name" => "ブログタイトルのフォントウェイト",
    	    "category" => "header",
            "id" => $shortname."_blog_title_weight",
            "type" => "select",
            "std" => "bold",
            "options" => array("bold", "normal"),
            "info" => "ブログタイトルをボールドにするかどうかを設定します."),
			
    array(    "name" => "ブログタイトルの色",
    	    "category" => "header",
            "id" => $shortname."_blog_title_color",
            "std" => "666666",
            "type" => "text",
            "info" => "ブログタイトルのデフォルトの色を設定します."),
			
    array(    "name" => "ポイント時のブログタイトルの色",
    	    "category" => "header",
            "id" => $shortname."_blog_title_color_hover",
            "std" => "000000",
            "type" => "text",
            "info" => "ポイントしたときのブログタイトルの色を設定します."),

    array(    "name" => "ブログタグラインの表示",
    	    "category" => "header",
            "id" => $shortname."_blog_tagline_show",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "ブログタグラインを表示しないように設定できます. ブログタグラインとは, 
		ブログタイトルの下に表示される簡潔なブログの定義のことです. Wordpressの設定 -> 一般 -> キャッチフレーズで
		設定できます."),
			
    array(    "name" => "ブログタグライン",
    	    "category" => "header",
            "id" => $shortname."_blog_tagline_style",
            "std" => "margin: 0;\npadding: 0;\nfont-size: 1.2em;\nfont-weight: bold;\ncolor: #666666;",
            "type" => "textarea-large",
            "info" => "ブログタグラインのスタイルを設定します."),
			
    array(    "name" => "検索ボックスの表示",
    	    "category" => "header",
            "id" => $shortname."_show_search_box",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "ヘッダーに検索ボックスを表示しないように設定できます.<br />
		<br /><em>検索ボックスをサイドバーの一要素として挿入するには,
		外観 -> " . $path_to_widgets . " -> ウィジェットで, 
		\"検索\"ウィジェットをサイドバーのいずれかに追加してください.</em>"),

	array(    "name" => "検索ボックス",
    	    "category" => "header",
            "id" => $shortname."_searchbox_style",
            "std" => "border: 1px dashed #cccccc;\nborder-bottom: 0;\nwidth: 200px;\nmargin: 0;\npadding: 0;",
            "type" => "textarea-large",
            "info" => "ヘッダーの検索ボックスのスタイルを設定します."),

	array(    "name" => "ヘッダーの検索ボックスのテキスト",
    	    "category" => "header",
            "id" => $shortname."_searchbox_text",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "<code>Type + Enter to search</code>など, ヘッダーの検索ボックスにデフォルトで表示される
		テキストを設定します."),

    array(    "name" => "水平バー1のスタイル",
    	    "category" => "header",
            "id" => $shortname."_horbar1",
            "std" => "height: 5px;\nbackground: #ffffff;\nborder-top: dashed 1px #cccccc;",
            "type" => "textarea-large",
            "info" => "2種類の水平バーが利用可能(必須ではありません)で, それぞれについて異なるスタイルを設定し, ヘッダーエリア
		の追加スタイル要素として何回でも利用することができます. これらのバーの幅はレイアウト幅全体になります. 
		4種類の枠線(上下左右)について, 背景色と高さを設定することができます."),

    array(    "name" => "水平バー2のスタイル",
    	    "category" => "header",
            "id" => $shortname."_horbar2",
            "std" => "height: 5px;\nbackground: #ffffff;\nborder-bottom: dashed 1px #cccccc;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "2種類目の水平バーのスタイルを設定します. いずれの種類の水平バーについて複数回利用する
		(もしくは利用しない)ことができます."),
			
// New category: header-image

    array(    "name" => "ヘッダーイメージ",
    	    "category" => "header-image",
			"switch" => "yes",
            "id" => $shortname."_header_image_info",
            "type" => "info",
            "info" => "<br />すべてのヘッダーイメージは<code>". $css_img_path ."images/header/</code>に格納されています. 
		このディレクトリに保存されているすべてのイメージがローテーションの対象となります. ヘッダーイメージをローテーション
		させたくないのであれば, このディレクトリに格納するイメージを1つだけにしてください. 
		<ul><li>レイアウト幅を固定に設定した場合, イメージの幅は<a href=\"javascript: myflowers.expandit('layout-tab')\">
		レイアウトの幅</a>で設定した値にする必要があります.</li>
		<li>レイアウト幅を可変に設定した場合, イメージの幅は\"最大レイアウト幅\"で設定した値にする必要があります.</li>
		<li>\"最大レイアウト幅\"を空欄にした場合は, イメージ幅は(訪問者の)最大画面解像度に合わせる必要があります. 
		現在であれば1280ピクセルが標準的ですので, イメージの幅はその幅もしくはそれ以上が望ましいでしょう. その次の目安は
		1440, 1600, 1680, 1920ピクセルになります. </li></ul>" . $header_image_text),

    array(    "name" => "ヘッダーイメージをJavascriptでのローテーション",
    	    "category" => "header-image",
            "id" => $shortname."_header_image_javascript",
            "type" => "select",
            "std" => "0",
            "options" => array(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30),
            "info" => "ローテーション間隔を秒数で指定します. 0に設定するとローテーションにJavascriptは利用されません. 
		この場合でも, ページがロードされる度にイメージはローテーションされますが, Javascriptは利用されません."),

    array(    "name" => "Javascriptによるローテーション時のイメージの先読み",
    	    "category" => "header-image",
            "id" => $shortname."_header_image_javascript_preload",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "Javascriptでローテーションする際に, イメージの先読みを行うかどうかを設定します. ヘッダーイメージを
		多数準備している場合は, \"No\"に設定しておくべきでしょう."),
			
    array(    "name" => "ヘッダーイメージのクリック",
    	    "category" => "header-image",
            "id" => $shortname."_header_image_clickable",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "\"Yes\"に設定すると, ヘッダイメージがクリックできるようになり, ホームページへのリンクになります."),

    array(    "name" => "ヘッダーイメージの高さ",
    	    "category" => "header-image",
            "id" => $shortname."_headerimage_height",
            "std" => "150",
            "type" => "text",
			"size" => "5",
            "info" => "<img src=\"" . $url_base . "/options/images/header-image-height.jpg\" 
		style=\"float: right; margin: 0 0 10px 10px;\">" . "ヘッダーイメージの画面上のサイズを, <strong>ピクセル単位</strong>で設定します. 
		この値を変更すると, 画面に表示されるヘッダーイメージの高さが変わります. <br /><br />
		<em>この値は, ヘッダーイメージの実際の高さと一致している必要はありません. 実際, すべてのヘッダイメージの(実際の)高さは異なっていて
		も構いません. 上からXXXピクセル(ここで設定した値)分のイメージが表示され, 残りの部分は隠されることになります. </em>"),

    array(    "name" => "ヘッダーイメージのアラインメント",
    	    "category" => "header-image",
            "id" => $shortname."_headerimage_alignment",
            "type" => "select",
            "std" => "top center",
            "options" => array("top center", "top left", "top right", "center left", "center center", "center right", 
			"bottom left", "bottom center", "bottom right"),
            "info" => "アラインメントが設定された側のイメージの端が固定されます. 訪問者のブラウザの状況によっては, 
		反対側のイメージの端がカットされます. <br /><br />
		<strong>例:</strong> もしあなたがアラインメントを\"Top Left\"と設定したとしたら, イメージは反対の端, 
		つまり\"Bottom Right\"からカットされます."),

    array(    "name" => "左側の不透明度の値",
    	    "category" => "header-image",
            "id" => $shortname."_header_opacity_left",
            "std" => "40",
            "type" => "select",
			"options" => array("0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", 
			"70", "75", "80", "85", "90", "95"),
            "info" => "<img src=\"" . $url_base . "/options/images/opacity.jpg\" style=\"float: right; 
		margin: 0 0 10px 10px;\">" . "ヘッダーイメージの左側のオーバーレイの不透明度を設定します.
		不透明にしない場合は0を選択してください."),

    array(    "name" => "左側の不透明部分の幅",
    	    "category" => "header-image",
            "id" => $shortname."_header_opacity_left_width",
            "std" => "200",
            "type" => "text",
			"size" => "5",
            "info" => "<img src=\"" . $url_base . "/options/images/opacity-left-width.jpg\" style=\"float: right; 
		margin: 0 0 10px 10px;\">" . "ヘッダーイメージの左端からの不透明のオーバーレイの幅を<strong>ピクセル単位で
		</strong>設定します. 左側のサイドバーの幅と合わせたい場合は, 左側のサイドバーの幅に(設定しているのならば)
		その左右のパディングを加算してください."),

    array(    "name" => "左側の不透明の色",
    	    "category" => "header-image",
            "id" => $shortname."_header_opacity_left_color",
            "std" => "ffffff",
            "type" => "text",
            "info" => "ヘッダーイメージの左側の不透明オーバーレイの色を設定します."),
			
    array(    "name" => "右側の不透明度の値",
    	    "category" => "header-image",
            "id" => $shortname."_header_opacity_right",
            "std" => "40",
            "type" => "select",
			"options" => array("0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", 
			"70", "75", "80", "85", "90", "95"),
            "info" => "<img src=\"" . $url_base . "/options/images/opacity.jpg\" style=\"float: right; 
		margin: 0 0 10px 10px;\">" . "ヘッダーイメージの右側のオーバーレイの不透明度を設定します.
		不透明にしない場合は0を選択してください."),

    array(    "name" => "右側の不透明部分の幅",
    	    "category" => "header-image",
            "id" => $shortname."_header_opacity_right_width",
            "std" => "200",
            "type" => "text",
			"size" => "5",
            "info" => "<img src=\"" . $url_base . "/options/images/opacity-right-width.jpg\" style=\"float: right; 
		margin: 0 0 10px 10px;\">" . "ヘッダーイメージの右側からの不透明のオーバーレイの幅を<strong>ピクセル単位で
		</strong>設定します. 右側のサイドバーの幅と合わせたい場合は, 右側(注:英語版は\"left\"でしたが, Typoだと思わ
		れるので修正)のサイドバーの幅に(設定しているのであれば)その左右のパディングを加算してください."),

    array(    "name" => "右側の不透明の色",
    	    "category" => "header-image",
            "id" => $shortname."_header_opacity_right_color",
            "std" => "ffffff",
            "type" => "text",
            "info" => "ヘッダイメージの右側の不透明オーバーレイの色を設定します."),

    array(    "name" => "ヘッダーイメージへのブログタイトルのオーバーレイ",
    	    "category" => "header-image",
            "id" => $shortname."_overlay_blog_title",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "ブログタイトルを置く場所のもう一つの選択肢."),

    array(    "name" => "ヘッダーイメージへのブログタグラインのオーバーレイ",
    	    "category" => "header-image",
            "id" => $shortname."_overlay_blog_tagline",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "ブログタグラインを置く場所のもう一つの選択肢."),

    array(    "name" => "オーバレイされたブログタイトル/タグラインのスタイル",
    	    "category" => "header-image",
            "id" => $shortname."_overlay_box_style",
            "std" => "margin-top: 30px;\nmargin-left: 30px;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "<img src=\"" . $url_base . "/options/images/header-overlay.jpg\" style=\"float: right; 
		margin: 0 0 10px 10px;\">" . "オーバレイされたブログタイトルとブログタグラインとは, divコンテナに含まれることになります. 
		<code>margin-top</code>および<code>margin-left</code>の値を変更すると, コンテナの場所を動かすことができます. 
		オーバレイされたコンテナを右に寄せたい場合は, <code>float: right;</code>を追加した上で, <code>margin-left</code> 
		を<code>margin-right</code>に変更します. 中央に置く場合は, <code>float:none; margin-left:auto; margin-right:auto; 
		text-align:center;</code>を追加した上で, margin-topをここに追加する代わりに, padding-topを親コンテナに追加します. 
		具体的には, <a href=\"javascript: myflowers.expandit('html-inserts-tab')\">HTML/CSSの挿入</a> -> CSSの挿入で, 
		<code>div.header-image-container { padding-top: 30px; height: XXXpx; }</code>を設定します. XXXには希望するイメージの
		高さ - padding-topの値を設定します.<br />
		<br />背景色, 枠線, パディングを追加することも可能です. 
		<br /><br /><strong>(イメージに示されてる)例:</strong><br /><br /><code>margin-top: 30px;<br />margin-left: 30px;<br />
		width: 300px;<br />padding: 7px;<br />background: #ffffff;<br />border: solid 2px #000000;<br />
		filter: alpha(opacity=60);<br />-moz-opacity:.60;<br />opacity:.60;<br />-moz-border-radius: 7px;<br />
		-khtml-border-radius: 7px;<br />-webkit-border-radius: 7px;<br />border-radius: 7px;</code><br /><br />
		ブログタイトルもしくはブログタグラインのいずれかが長くなった場合にボックスを自動的に調整させたいのであれば, 
		<code>width: ...;</code>の設定は省略します.<br />
		<br />ブログタイトルとブログタグラインとのスタイルをそれぞれ独自に変更したい場合は, メニュータブの\"ヘッダー\"を参照してください."),        

// New category: feed-links

    array(    "name" => "RSSの設定",
    	    "category" => "feed-links",
			"switch" => "yes",
            "id" => $shortname."_rss_settings_info",
            "type" => "info",
            "info" => "<br />4つのタイプのRSSのリンクのいずれかを選択します:<ul>
		<li>投稿のフィードを購読する</li>
		<li>コメントのフィードを購読する</li>
		<li>Emailで購読する(Feedburner経由)</li>
		<li>任意の投稿のコメントを購読する</li></ul>
		これらのRSSリンクを設置できる場所は, 4か所あります:<ul>
		<li>ロゴエリアの右側: 小さなボタンあるいはテキストリンク(もしくは両方).<br />設定: メニュータブの\"RSSの設定\"(現在みているこのページ)</li>
		<li>\"BFAの購読\"ウィジェット経由でのサイドバーの中. より大きなボタンとテキスト, 更に電子メールフォームフィールドも含まれます.<br />
		設定: WordPressの管理画面 -> 外観 (古いバージョンの場合は\"デザイン\"もしくは\"プレゼンテーション\") -> <a href='widgets.php'>ウィジェット</a>
		-> BFAの購読.</li>
		<li>フッターエリア内: テキストリンク.<br />設定: メニュータブの
		<a href=\"javascript: myflowers.expandit('footer-style-tab')\">フッターのスタイルと編集</a> -> フッターのコンテンツ.</li>
		<li>投稿の上もしくは下: ボタンあるいはテキストリンク(もしくは両方)<br />設定: メニュータブの
		<a href=\"javascript: myflowers.expandit('postinfos-tab')\">投稿/ページ情報アイテムの編集</a> -> 任意の12テキストエリア.</li></ul>
		すべてを設定したら...<ul>
		<li>...\"電子メールで購読する\"のリンクはFeedburnerにリンクされます</li>
		<li>...\"電子メールで購読する\"のフォームフィールドは, Feedburnerに送信されるようになります</li>
		<li>...しかし, すべての投稿とコメントのフィードのリンクは, WordpressのデフォルトのRSSリンクにリンクされた状態になります</li></ul>
		<strong>すべての投稿とコメントのRSSリンクをFeedburnerにリダイレクトしたい場合は, 
		<a href=\"http://www.google.com/support/feedburner/bin/answer.py?answer=78483&topic=13252\">Feedburner Feedsmith</a> 
		プラグインをインストールする必要があります.</strong>
		<em>ノート: FeedburnerのフィードURLを, あなたのFeedburnerのアカウントからあなたのブログのFeedsmithのオプションページにコピー & ペーストをする際には, 
		URLもしくはFeedburnerのアカウント名の最後に<strong>スペースがないこと</strong>を確認してください.</em><br /><br />
		AtahualpaはRSSの購読者(電子メールでの購読者は除く)を直接Feedburnerには送り込みません. なぜならば...<ul>
		<li>...既存の購読者をカバーすることができないため</li>
		<li>...サードパーティー製のプラグインが追加するRSSリンクまで含めて, Feedsmithはあなたのサイトに存在するあらゆるRSSリンクをカバーする
		グローバルなソリューションであるため</li>
		<li>...Feedsmithのリダイレクションを利用すれば, 読者が購読するURLをあなたがコントロールできるため(http://www.yourdomain.com/feed/).
		Feedburnerの利用を停止したい場合は場合は, Feedsmithプラグインをアンストールするだけですべての購読者を確保できます. 彼らはもう
		リダイレクトされないのです.</li></ul>"),

	array(    "name" => "RSSボックスの幅",
    	    "category" => "feed-links",
            "id" => $shortname."_rss_box_width",
            "std" => "280",
            "type" => "text",
            "info" => "<img src=\"" . $url_base . "/options/images/rss-box.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
		"RSSボタン/リンクが格納されるボックスの固定幅を<strong>ピクセル単位で</strong>指定することにより, 一行に収まるよう, 
		また折り返されないようにします. コンテンツの大きさから考えて不必要に広い値を設定しないようにしてください."),
			
    array(    "name" => "投稿のフィードのアイコンの表示",
    	    "category" => "feed-links",
            "id" => $shortname."_show_posts_icon",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "<img src=\"" . $url_base . "/options/images/show_posts_icon.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"投稿のRSSフィードのアイコンをロゴエリアの右側に表示するかどうかを設定します."),

	array(    "name" => "投稿のフィードのリンクテキスト",
    	    "category" => "feed-links",
            "id" => $shortname."_post_feed_link",
            "std" => __("Posts","atahualpa"),
            "type" => "text",
            "info" => "<img src=\"" . $url_base . "/options/images/post_feed_link.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"投稿のフィードのリンクテキストを表示しない場合は, 空欄にしてください."),		

	array(    "name" => "投稿のフィードのリンクの\"タイトル\"",
    	    "category" => "feed-links",
            "id" => $shortname."_post_feed_link_title",
            "std" => __("Subscribe to the POSTS feed","atahualpa"),
            "type" => "text",
			"size" => "30", 
            "info" => "<img src=\"" . $url_base . "/options/images/post_feed_link_title.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
		"リンクアンカーテキストではなく(それは直前のオプションで設定します), マウスがリンクにポイントされたときにポップアップする
		リンクの\"タイトル\"となるテキストです"),		

    array(    "name" => "コメントのフィードのアイコンの表示",
    	    "category" => "feed-links",
            "id" => $shortname."_show_comments_icon",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "<img src=\"" . $url_base . "/options/images/show_comments_icon.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" .
			"コメントのRSSフィードのアイコンをロゴエリアの右側に表示するかどうかを設定します."),

	array(    "name" => "コメントのフィードのリンクテキスト",
    	    "category" => "feed-links",
            "id" => $shortname."_comment_feed_link",
            "std" => __("Comments","atahualpa"),
            "type" => "text",
            "info" => "<img src=\"" . $url_base . "/options/images/comment_feed_link.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" .
			"コメントのフィードのリンクテキストを表示しない場合は, 空欄にしてください."),

	array(    "name" => "コメントのフィードのリンクの\"タイトル\"",
    	    "category" => "feed-links",
            "id" => $shortname."_comment_feed_link_title",
            "std" => __("Subscribe to the COMMENTS feed","atahualpa"),
            "type" => "text",
			"size" => "30", 
            "info" => "<img src=\"" . $url_base . "/options/images/comment_feed_link_title.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" .
		"リンクアンカーテキストではなく(それは直前のオプションで設定します), マウスがリンクにポイントされたときにポップアップする
		リンクの\"タイトル\"となるテキストです"),

    array(    "name" => "Feedburnerの電子メールのアイコンの表示",
    	    "category" => "feed-links",
            "id" => $shortname."_show_email_icon",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "<img src=\"" . $url_base . "/options/images/show_email_icon.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"Feedburnerの\"電子メールで購読\"のアイコンをロゴエリアの右側に表示するかどうかを設定します."),

	array(    "name" => "Feedburnerの電子メールのリンクテキスト",
    	    "category" => "feed-links",
            "id" => $shortname."_email_subscribe_link",
            "std" => __("By Email","atahualpa"),
            "type" => "text",
            "info" => "<img src=\"" . $url_base . "/options/images/email_subscribe_link.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"\"電子メールで購読\"のリンクテキストを表示しない場合は, 空欄にしてください."),

	array(    "name" => "Feedburnerの電子メールのリンクの\"タイトル\"",
    	    "category" => "feed-links",
            "id" => $shortname."_email_subscribe_link_title",
            "std" => __("Subscribe by EMAIL","atahualpa"),
            "type" => "text",
			"size" => "30", 
            "info" => "<img src=\"" . $url_base . "/options/images/email_subscribe_link_title.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
		"リンクアンカーテキストではなく(それは直前のオプションで設定します), マウスがリンクにポイントされたときにポップアップする
		リンクの\"タイトル\"となるテキストです"),
			
    array(    "name" => "このサイトのFeedburner IDの設定",
    	    "category" => "feed-links",
            "id" => $shortname."_feedburner_email_id",
            "type" => "text",
            "std" => "",
			"size" => "25", 
            "info" => "Feedburnerの\"電子メールで購読\"のリンクを表示する場合は, このサイトのFeedburnerのフィードのIDをここで設定します. 
		<br /><br />feedburner.comで取得された古いIDを持っている場合は, IDは番号(7桁程度)になります. feedburner.google.comで取得した
		新しいアカウントを持っている場合は, IDは番号ではなく, あなたのサイト名から空白を取り除いたのに近い文字列になるはずです. 
		<br /><br />あなたのFeedburnerアカウントにログインしてから, \"マイフィード\" -> \"[対象のフィード/サイトのタイトル]\" 
		-> \"集客支援\" -> \"フィード・メールマガジン\"をクリックしてください(フィード・メールマガジンを有効にしていない場合は, ここで有効に
		してから次のステップに進んでください). この画面で表示されている2つのテキストエリアを確認してください. <br /><br />
		<strong>持っているのがfeedburner.google.comのアカウントの場合:</strong> 
		2つのテキストエリアのうち, 下にある小さい方のテキストエリアに, こんなテキストが含まれているはずです: 
		<code>feedburner.google.com/fb/a/mailverify?uri=<i>bytesforall/lzoG</i>&amp;loc=en_US</code>
		ハイライトされたテキストが, あなたのGoogle/FeedburnerのIDになります. 
		ノート: <strong>bytesforall/lzoG</strong>はあなたのIDではありません. これは, 単にIDがどこから開始されていてどこで終わるかを示すサンプル
		に過ぎません. IDは<code>?uri=</code>の後から始まり, <code>&amp;loc=</code>の前で終わります.<br /><br />
		<strong>持っているのが(古い, オリジナルの)feedburner.comのアカウントの場合:</strong> 
		古いfeedburnerのアカウントを利用している場合ということは, それがGoogleに移管されていないということです. 
		2つのテキストエリアのうち, 下にある小さい方のテキストエリアに, こんなテキストが含まれているはずです: 
		<code>www.feedburner.com/fb/a/emailverifySubmit?feedId=<i>1234567</i>&amp;loc=en_US</code>
		ハイライトされた番号が, あなたの(古い, オリジナルの)Feedburner.comのIDになります. 
		ノート: <strong>1234567</strong>はあなたのIDではありません. これは, 単にIDがどこから開始されていてどこで終わるかを示すサンプルに過ぎません.
		IDは<code>?feedId=</code>の後から始まり, <code>&amp;loc=</code>の前で終わります.<br /><br />	
		自分の(新しいGoogle/Feedburner, もしくは古いFeedburner.comの)IDがわかったら, それをここのフィールドに設定してください."),

    array(    "name" => "Feedburnerのアカウントの新旧",
    	    "category" => "feed-links",
            "id" => $shortname."_feedburner_old_new",
            "type" => "select",
            "std" => "New - at feedburner.google.com",
			"lastoption" => "yes", 
            "options" => array("New - at feedburner.google.com", "Old - at feedburner.com"),
            "info" => "あなたのアカウントの新旧は, あなたのログイン先がfeedburner.comであるかfeedburner.google.comであるかとは関係ありません. 
		ひとつ前のオプションを参照して, あなたのアカウントが古いアカウントか新しいアカウントかを判断してください."),

// New category: page-menu-bar

    array(    "name" => "ページメニューバのホームへのリンク",
    	    "category" => "page-menu-bar",
			"switch" => "yes",
            "id" => $shortname."_home_page_menu_bar",
            "std" => __("Home","atahualpa"),
            "type" => "text",
            "info" => "<ul><li>ページメニューバーに\"ホーム\"へのリンクを含めたくない場合は, 空欄にしておいてください</li>
		<li>ページメニューバーにホームページへのリンクを含めたい場合は, そのテキストを設定します</li>
		<li>テキストは\"ホーム\"である必要はなく, 任意の文字列を設定できます</li></ul>"),

    array(    "name" => "ページメニューバーから除外するページの設定",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_exclude_page_menu_bar",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "<ul><li>すべてのページをページメニューバーに含める場合は, 空欄にしておいてください</li>
		<li>特定のページを除外したい場合は, それらのIDをこのフィールドにコンマ区切りで設定します</li></ul>
		<strong>例:</strong> <code>13,29,102,117</code><br /><br />
		ページのIDを確認するには, WordPressの管理画面 -> ページ -> <a href=\"edit-pages.php\">編集</a>で対象のページのタイトルに
		マウスをポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&post=<strong>XX</strong>\"のよう
		なURLの最後を確認します. <strong>XX</strong>がページのIDになります."),

    array(    "name" => "ページメニューバーの階層",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_levels_page_menu_bar",
            "std" => "0",
            "type" => "select",
            "options" => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
            "info" => "<ul><li>ページメニューバーにすべてのレベルのページ(トップレベル, サブページ, サブサブページ...)を含む場合は, 0を選択します</li>
		<li>階層の深さを指定したい場合は, 1から10の間でページレベルを指定します</li></ul>"),

    array(    "name" => "ページメニューバーのソート順",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_sorting_page_menu_bar",
            "type" => "select",
            "std" => "menu_order",
            "options" => array("menu_order", "post_title"),
            "info" => "<ul><li><code>menu_order</code> - ページを作成順に時系列でソートします
		(ソート順を変えるには, WordPressの管理画面 -> ページ -> ページタイトルをクリック -> 順序)</li>
		<li><code>post_title</code> - アルファベット順</li></ul>"),

    array(    "name" => "ページメニューバーのタイトルタグ",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_titles_page_menu_bar",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "\"タイトル\"タグをページメニューのアイテムに含めるかどうかを設定します. 
		これらはメニューアイテムにマウスを合わせた時にポップアップします."),

    array(    "name" => "ページメニューバーの最上位の親アイテムのリンク",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_1st_level_not_linked",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "ここをYes(原文はNoだが, Typoと思われる)に設定すると, 最上位の親アイテムのリンクターゲットが&lt;a href=\"#\"&gt;に置換されます. 
		この設定で, 子アイテムを持つ最上位のメニューアイテムのリンクが外されます. リンクをポイントするとサブメニューがドロップダウンしますが, 
		リンクをクリックしても何も起りません. メインページを利用してページを構成したい, でもメインページにはコンテンツを持たせたくない
		という利用者向けの設定です. \"Yes\"は, \"はい, リンクしません\"という意味になります."),
			
    array(    "name" => "任意のメニューアイテムの枠線",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_anchor_border_page_menu_bar",
            "std" => "dashed 1px #cccccc",
            "type" => "text",
            "info" => "メニューバーの各アイテムとメニューバー自身は, ここで設定した枠線の中で折り返されます. 
		最上位のアイテムについて枠線を設定したくない場合は, 背景色と最上位のアイテムの色をあわせてください. 
		ここではセミコロンは利用しないでください.<br /><br />
		ノート: 不可視状態にしたい場合は, 枠線の幅を1ピクセルにした上で, 色を合わせてください."),

    array(    "name" => "背景色",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_bar_background_color",
            "std" => "ffffff",
            "type" => "text",
            "info" => "メニューアイテムとメニューバーのデフォルト状態の背景色を設定します."),


    array(    "name" => "ポイント時の背景色",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_bar_background_color_hover",
            "std" => "eeeeee",
            "type" => "text",
            "info" => "マウスでポイントされてカレント状態になった際のメニューアイテムの背景色を設定します. 
		IE7/IE8には\"White Background Hover Bug\"があるため, <strong>ffffffの代わりにfffffeに設定してください</strong>. 
		 http://haslayout.net/css/Hover-White-Background-Ignore-Bug. "),

    array(    "name" => "親メニューアイテムの背景色",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_bar_background_color_parent",
            "std" => "dddddd",
            "type" => "text",
            "info" => "サブメニューをポイントしている間の親メニューアイテムの背景色を設定します.
		IE7/IE8には\"White Background Hover Bug\"があるため, <strong>ffffffの代わりにfffffeに設定してください</strong>. 
		 http://haslayout.net/css/Hover-White-Background-Ignore-Bug. "),

    array(    "name" => "フォントサイズとフォントフェイスの設定",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_font",
            "std" => "11px Arial, Verdana, sans-serif",
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "メニューアイテムのフォントサイズとフォントフェイスの両方を設定します. 
		フォントフェイスにスペースが含まれる場合は, 二重引用符で括ってください.
		例:<br /><code>12px \"comic sans ms\", \"courier new\", arial, sans-serif</code><br />
		<br />ここではセミコロンは利用しないでください."),

    array(    "name" => "リンクカラー",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_bar_link_color",
            "std" => "777777",
            "type" => "text",
            "info" => "リンクが設定されたテキストの色を設定します."),

    array(    "name" => "ポイント時のリンクカラー",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_bar_link_color_hover",
            "std" => "000000",
            "type" => "text",
            "info" => "マウスでポイントされた時のリンクカラーを設定します."),
	
    array(    "name" => "ページメニューバーのテキストの変換",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_transform",
            "type" => "select",
            "std" => "uppercase",
            "options" => array("uppercase", "lowercase", "capitalize", "none"),
            "info" => "ページメニューバーのリンクタイトルを変換することができます."),

    array(    "name" => "サブメニューの矢印の色",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_arrows",
            "type" => "select",
            "std" => "black",
            "options" => array("black", "white"),
            "info" => "メニューアイテムにサブメニューがある場合, 下方向/右方向の矢印が表示されます. 
		その矢印の色を選択してください."),

    array(    "name" => "サブメニューの幅",
    	    "category" => "page-menu-bar",
            "id" => $shortname."_page_menu_submenu_width",
            "type" => "select",
            "std" => "11",
			"lastoption" => "yes", 
			"options" => array("7", "7.5", "8", "8.5", "9", "9.5", "10", "10.5", "11", "11.5", "12", "12.5", "13", 
			"13.5", "14", "14.5", "15", "15.5", "16", "16.5", "17", "17.5", "18", "18.5", "19", "19.5", "20", "20.5", 
			"21", "21.5", "22", "22.5", "23", "23.5", "24", "24.5", "25"),
            "info" => "最上位のアイテムの幅は, そのリンクの幅に合わせて調整されます. 
		しかし, サブメニューは幅を<strong>\"em\"で</strong>設定する必要があります."),
			
// New category: cat-menu-bar

    array(    "name" => "カテゴリメニューバーのホームへのリンク",
    	    "category" => "cat-menu-bar",
			"switch" => "yes",
            "id" => $shortname."_home_cat_menu_bar",
            "std" => "",
            "type" => "text",
            "info" => "<ul><li>カテゴリメニューバーに\"ホーム\"へのリンクを含めたくない場合は, 空欄にしておいてください</li>
		<li>カテゴリメニューバーにホームページへのリンクを含めたい場合は, そのテキストを設定します</li>
		<li>テキストは\"ホーム\"である必要はなく, 任意の文字列を設定できます</li></ul>"),

    array(    "name" => "カテゴリメニューバーから除外するカテゴリの設定",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_exclude_cat_menu_bar",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "<ul><li>すべてのカテゴリをカテゴリメニューバーに含める場合は, 空欄にしておいてください</li>
		<li>特定のカテゴリを除外したい場合は, そのIDをこのフィールドにコンマ区切りで設定します</li></ul>
		<strong>例:</strong> <code>13,29,102,117</code><br /><br />
		カテゴリのIDを確認するには, WordPressの管理画面 -> 投稿 -> <a href=\"categories.php\">カテゴリ</a>で対象のカテゴリのタイトルを
		マウスでポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&cat_ID=<strong>XX</strong>\"のような
		URLの最後を確認します. <strong>XX</strong>がカテゴリのIDになります."),

    array(    "name" => "カテゴリメニューバーの階層",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_levels_cat_menu_bar",
            "std" => "0",
            "type" => "select",
            "options" => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
            "info" => "<ul><li>カテゴリメニューバーにすべてのレベルのカテゴリ(トップレベル, サブカテゴリ, サブサブカテゴリ...)を含む場合は, 0を選択します</li>
		<li>階層の深さを指定したい場合は, 1から10の間でカテゴリレベルを指定します</li></ul>"),

    array(    "name" => "カテゴリメニューバーのソート順",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_sorting_cat_menu_bar",
            "type" => "select",
            "std" => "ID",
            "options" => array("ID", "name", "count", "order"),
            "info" => '<ul><li><code>ID</code> - カテゴリを作成順に時系列でソートします</li>
		<li><code>name</code> - アルファベット順</li>
		<li><code>count</code> - 投稿数順</li>
		<li><code>order</code> - 個別に, <a href="http://wordpress.org/extend/plugins/my-category-order/">My Category Order</a>
		プラグイン(このプラグインのインストールが必要です)のオプションページの設定に従って</li></ul>'),

    array(    "name" => "カテゴリメニューバーのソート方式",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_order_cat_menu_bar",
            "type" => "select",
            "std" => "ASC",
            "options" => array("ASC", "DESC"),
            "info" => "カテゴリを昇順(ASC)と降順(DESC)のどちらでソートするかを設定します."),		
			
    array(    "name" => "カテゴリメニューバーのタイトルタグ",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_titles_cat_menu_bar",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "\"タイトル\"タグをカテゴリメニューバーのアイテムに挿入するかどうかを設定します. タイトルタグは, メニュー
		アイテムにマウスを合わせた際にポップアップする小さなボックスのことです. 各カテゴリの\"定義\"
		(Wordpressの管理画面 -> カテゴリ -> カテゴリ名をクリック)を設定しているのであれば, 有効にするべきでしょう. 
		設定していなければ, タイトルタグはカテゴリ名を単純に繰り返すだけになります."),

    array(    "name" => "メニューバータブへのカテゴリ定義の追加",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_add_descr_cat_menu_links",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "この設定を有効にすると, カテゴリメニューバーの各カテゴリボタンのラインテキストにラインブレーク &lt;br /&gt; が追加されて, 
		その後に\"カテゴリの定義\" (Wordpressの管理画面 -> 投稿 -> カテゴリ -> 定義で設定)が表示されるようになります. 
		このカテゴリの定義がメニューボタンの内部に表示される際に利用されるスタイルは, HTML/CSSの挿入 -> 
		CSSの挿入で設定できます. 例: <code>span.cat-descr { font-size: 90%; text-tranform: none; }</code>"),

    array(    "name" => "デフォルトのカテゴリ定義テキスト",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_default_cat_descr_text",
            "std" => "View all posts filed under<br />%category%",
            "type" => "text",
			"size" => "30", 
			"editable" => "yes",
            "info" => "メニューバーのリンクテキストにカテゴリの定義を表示するように設定した場合, 定義が設定されていないカテゴリに
		対応するデフォルトのテキストを設定できます. <code>%category%</code>がプレースホルダとなり, カテゴリタイトルと
		置き換えられます. HTMLも利用可能できます."),
			
    array(    "name" => "メニューアイテムを囲む枠線",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_anchor_border_cat_menu_bar",
            "std" => "solid 1px #000000",
            "type" => "text",
            "info" => "メニューバーの各アイテムとメニューバー自体は枠線で囲まれます. 
		最上位のレベルで枠線を表示させないようにするには, 最上位レベルのアイテムの背景色を同じ色を設定します. 
		ここではセミコロンは利用しないでください. <br /><br />ノート: 枠線の幅は1ピクセルのままにしておいてください. 
		表示させたくない場合は, 色を合わせるようにしてください."),

    array(    "name" => "背景色",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_bar_background_color",
            "std" => "777777",
            "type" => "text",
            "info" => "メニューアイテムおよびメニューバー自体の, デフォルト状態の背景色を設定します."),

    array(    "name" => "ポイント時の背景色",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_bar_background_color_hover",
            "std" => "cc0000",
            "type" => "text",
            "info" => "ポイントされてカレント状態になった際の背景色を設定します. 
		IE7/IE8には\"White Background Hover Bug\"があるため, <strong>ffffffの代わりにfffffeに設定してください</strong>. 
		 http://haslayout.net/css/Hover-White-Background-Ignore-Bug. "),

    array(    "name" => "親の背景色",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_bar_background_color_parent",
            "std" => "000000",
            "type" => "text",
            "info" => "サブメニューがポイントされている際の親メニューアイテムの背景色を設定します. 
		IE7/IE8には\"White Background Hover Bug\"があるため, <strong>ffffffの代わりにfffffeに設定してください</strong>. 
		 http://haslayout.net/css/Hover-White-Background-Ignore-Bug. "),
			
    array(    "name" => "カテゴリメニューバーのフォント",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_font",
            "std" => "11px Arial, Verdana, sans-serif",
            "type" => "text",
			"size" => "30", 
            "editable" => "yes", 
            "info" => "メニューアイテムのフォントサイズとフォントフェイスを設定します.
		フォントフェイスにスペースが含まれる場合は, 二重引用符で括ってください.
		例:<br /><code>12px \"comic sans ms\", \"courier new\", arial, sans-serif</code><br />
		<br />ここではセミコロンは利用しないでください."),

    array(    "name" => "リンクの色",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_bar_link_color",
            "std" => "ffffff",
            "type" => "text",
            "info" => "デフォルト状態のリンクテキストの色を設定します."),

    array(    "name" => "ポイント時のリンクの色",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_bar_link_color_hover",
            "std" => "ffffff",
            "type" => "text",
            "info" => "ポイントされた状態のリンクテキストの色を設定します."),
			
    array(    "name" => "カテゴリメニューバーのテキストの変換",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_transform",
            "type" => "select",
            "std" => "uppercase",
            "options" => array("uppercase", "lowercase", "capitalize", "none"),
            "info" => "カテゴリメニューバーのリンクタイトルの変換方法を設定します."),
			
    array(    "name" => "サブメニューインディケーターの矢印の色の設定",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_arrows",
            "type" => "select",
            "std" => "white",
            "options" => array("white", "black"),
            "info" => "メニューアイテムにサブメニューがある場合, 下/右方向の矢印が表示されます. 
			これらの矢印の色を設定します."),

    array(    "name" => "サブメニューの幅",
    	    "category" => "cat-menu-bar",
            "id" => $shortname."_cat_menu_submenu_width",
            "type" => "select",
            "std" => "11",
			"lastoption" => "yes", 
			"options" => array("7", "7.5", "8", "8.5", "9", "9.5", "10", "10.5", "11", "11.5", "12", "12.5", 
			"13", "13.5", "14", "14.5", "15", "15.5", "16", "16.5", "17", "17.5", "18", "18.5", "19", "19.5", "20", 
			"20.5", "21", "21.5", "22", "22.5", "23", "23.5", "24", "24.5", "25"),
            "info" => "最上位のアイテムの幅は, そのリンクの幅に合わせて調整されます. 
		しかし, サブメニューは幅を<strong>\"em\"で</strong>設定する必要があります."),

// new category: center

	array(    "name" => "中央カラムのスタイル",
    	    "category" => "center",
			"switch" => "yes",
            "id" => $shortname."_center_column_style",
            "std" => "padding: 10px 15px;",
            "type" => "textarea-large",
            "info" => "中央カラムのスタイルを設定します. 中央カラムは, 中央に表示されるすべてのコンテナです. 
		具体的には, すべての投稿(\"ページ\"の投稿も含む)と次/以前のナビゲーションが含まれます."),

	array(    "name" => "ループの前のコンテンツ",
    	    "category" => "center",
            "id" => $shortname."_content_above_loop",
            "std" => "<?php /* For MULTI post pages if activated at ATO -> Next/Previous Navigation: */
bfa_next_previous_page_links('Top'); ?>

<?php /* For the plugin Page2Cat http://wordpress.org/extend/plugins/page2cat/ */
if( is_category() AND function_exists('page2cat_output')) { page2cat_output(\$cat); } ?>",
            "type" => "textarea-large",
            "info" => "ループの前のコンテンツの編集/追加/削除を行います. ループとは, 特定のページにWordpressが出力するコンテンツのことです. 
		投稿のリスト(このため\"ループ\"という名前になっています. なぜならば, 任意の投稿のリストのページに表示される投稿は\"ループ\"するからです.), 
		単一のポストもしくは静的なページのいずれも該当します. 単一のポスト/静的なページでは実際にループするわけではありませんが, それでもループと呼びます. 
		この部分とこの下の他のテキストエリアでは, HTMLと<strong>PHP</strong>が利用可能です."),

	array(    "name" => "ループ",
    	    "category" => "center",
            "id" => $shortname."_content_inside_loop",
            "std" => "<?php /* For SINGLE post pages if activated at ATO -> Next/Previous Navigation: */
bfa_next_previous_post_links('Top'); ?>

<?php /* Post Container starts here */
if ( function_exists('post_class') ) { ?>
<div <?php if ( is_page() ) { post_class('post'); } else { post_class(\"\$odd_or_even\"); } ?> id=\"post-<?php the_ID(); ?>\">
<?php } else { ?>
<div class=\"<?php echo ( is_page() ? 'page ' : '' ) . \$odd_or_even . ' post\" id=\"post-'; the_ID(); ?>\">
<?php } ?>

<?php bfa_post_kicker('<div class=\"post-kicker\">','</div>'); ?>

<?php bfa_post_headline('<div class=\"post-headline\">','</div>'); ?>

<?php bfa_post_byline('<div class=\"post-byline\">','</div>'); ?>

<?php bfa_post_bodycopy('<div class=\"post-bodycopy clearfix\">','</div>'); ?>

<?php bfa_post_pagination('<p class=\"post-pagination\"><strong>'.__('Pages:','atahualpa').'</strong>','</p>'); ?>

<?php bfa_post_footer('<div class=\"post-footer\">','</div>'); ?>

</div><!-- / Post -->",
            "type" => "textarea-large",
            "info" => "ここでは, 単一ポストの間にコンテンツを追加するなど, ループの編集ができます. 任意の投稿の後に何かを
		置きたい場合は, <code>\$bfa_ata['postcount']</code>という変数を利用するといいでしょう. この変数は, 現在ループ
		に含まれている投稿数を保持しています. <br /><br />
		<strong>例:</strong><br /><br /><code>&lt;?php if ( \$bfa_ata['postcount'] == 1 ) { ?&gt;<br /><br />
		ここで設定したHTML, Javascript, PHPは, 最初の投稿の後に表示されます.<br /><br />
		&lt;?php } ?&gt;</code>
		<br /><br /><strong>例 2:</strong><br /><br />
		<code>&lt;?php if ( is_front_page() AND \$bfa_ata['postcount'] == 3 ) { ?&gt;<br /><br />
		ここの内容は, ホームページの3番目の投稿の後に(だけ)表示されます.<br /><br />
		&lt;?php } ?&gt;</code>"),
						
	array(    "name" => "ループの後のコンテンツ",
    	    "category" => "center",
            "id" => $shortname."_content_below_loop",
            "std" => "<?php /* Displayed on SINGLE post pages if activated at ATO -> Next/Previous Navigation: */
bfa_next_previous_post_links('Middle'); ?>

<?php /* Load Comments template (on single post pages, and static pages, if set on options page): */
bfa_get_comments(); ?>

<?php /* Displayed on SINGLE post pages if activated at ATO -> Next/Previous Navigation: */
bfa_next_previous_post_links('Bottom'); ?>
		
<?php /* Archives Pages. Displayed on a specific static page, if configured at ATO -> Archives Pages: */
bfa_archives_page('<div class=\"archives-page\">','</div>'); ?>
			
<?php /* Displayed on MULTI post pages if activated at ATO -> Next/Previous Navigation: */
bfa_next_previous_page_links('Bottom'); ?>",
            "type" => "textarea-large",
            "info" => "ループの下のコンテンツを, ここで追加/削除/編集します."),		

	array(    "name" => "コンテンツがない場合",
    	    "category" => "center",
            "id" => $shortname."_content_not_found",
            "std" => "<h2><?php _e('Not Found','atahualpa'); ?></h2>
<p><?php _e(\"Sorry, but you are looking for something that isn't here.\",\"atahualpa\"); ?></p>",
            "type" => "textarea-large",
				"lastoption" => "yes", 
            "info" => "\"404 Not Found\"のページに表示されるコンテンツをここで追加/編集/削除します."),		
            
            
// New category: next/prev navigation
			
    array(    "name" => "次 / 前のナビゲーション",
    	    "category" => "next-prev-nav",
			"switch" => "yes",
            "id" => $shortname."_next_prev_orientation",
            "std" => "Newer Left, Older Right",
            "type" => "select", 
			"options" => array("Newer Left, Older Right", "Older Left, Newer Right"), 
            "info" => "ナビゲーションバーの左側/右側のどちらに, 次のポスト/ページへのリンクを表示するかを設定します."),
			
    array(    "name" => "複数投稿ページのナビゲーションでのホームリンクの表示",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_home_multi_next_prev",
            "std" => "",
            "type" => "text",
            "info" => "複数の投稿が表示されるページで, 前後の投稿へのリンクの間に\"Home\"へのリンクを表示するかどうかを設定します. 
			<ul><li>\"Home\"へのリンクを表示したくない場合は, 空欄のままにしておいてください</li>
			<li>ここで設定された任意のテキストは, ホームページへのリンクのテキストとして利用されます</li>
			<li>もしあなたがWP-PageNaviプラグインを利用しているのであれば, WP-PageNaviのページ番号がデフォルトの次/以前
			へのリンクの代わりに表示されるため, この設定は意味を持ちません</li></ul>"),

    array(    "name" => "単一投稿ページのナビゲーションでのホームリンクの表示",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_home_single_next_prev",
            "std" => "",
            "type" => "text",
            "info" => "単一の投稿が表示されるページで, 前後の投稿へのリンクの間に\"Home\"へのリンクを表示するかどうかを設定します. 
			<ul><li\"Home\"へのリンクを表示したくない場合は, 空欄のままにしておいてください</li>
			<li>ここで設定された任意のテキストは, ホームページへのリンクのテキストとして利用されます</li></ul>"),

    array(    "name" => "複数投稿表示ページでの\"次のページ\"のリンクの表示",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_multi_next_prev_newer",
            "std" => __("&laquo; Newer Entries","atahualpa"),
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "単一/二重引用符, HTMLが利用できます. 例:<ul>
			<li><code>&lt;br /&gt;</code>でラインブレークが入ります</li>
			<li><code>&lt;strong&gt; ... &lt;/strong&gt;</code>でテキストが<strong>ボールド</strong>になります</li>
			<li><code>&lt;em&gt; ... &lt;/em&gt;</code>でテキストが<em>イタリック</em>になります</li>
			<li><code>&amp;nbsp;</code>でノーブレークスペースが入ります</li>
			<li><code>&amp;raquo;</code>で右二重ギュメが入ります<span style=\"font-size: 25px\">&raquo;</span></li>
			<li><code>&amp;laquo;</code>で左二重ギュメが入ります<span style=\"font-size: 25px\">&laquo;</span></li>
			<li><code>&amp;rsaquo;</code>で右一重ギュメが入ります<span style=\"font-size: 25px\">&rsaquo;</span></li>
			<li><code>&amp;lsaquo;</code>で左一重ギュメが入ります<span style=\"font-size: 25px\">&lsaquo;</span></li>
			<li><code>&amp;rarr;</code>で右矢印が入ります<span style=\"font-size: 25px\">&rarr;</span></li>
			<li><code>&amp;larr;</code>で左矢印が入ります<span style=\"font-size: 25px\">&larr;</span></li></ul>
			<em>ノート: あなたがWP-PageNaviを利用しているのであれば, こことこの次の設定は意味を持ちません</em>"), 

    array(    "name" => "複数投稿ページでの\"前のページ\"のリンク",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_multi_next_prev_older",
            "std" => __("Older Entries &raquo;","atahualpa"),
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "上のHTMLサンプルを参照してください."), 

    array(    "name" => "単一投稿ページでの\"次の投稿\"のリンク",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_single_next_prev_newer",
            "std" => "&laquo; %link",
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "上のHTMLサンプルを参照してください.<br /><br />次の投稿のタイトルをリンクしたい場合は, <code>%link</code>としてください."), 
			
    array(    "name" => "単一投稿ページでの\"前の投稿\"のリンク",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_single_next_prev_older",
            "std" => "%link &raquo;",
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "上のHTMLサンプルを参照してください.<br /><br />前の投稿のタイトルをリンクしたい場合は, <code>%link</code>としてください."),

);

$options2 = array(

    array(    "name" => "コメントナビゲーションでの\"次のコメント\"のリンク",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_comments_next_prev_newer",
            "std" => __("Newer Comments &raquo;","atahualpa"),
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "上のHTMLサンプルを参照してください. ページ番号を表示するように設定した場合(下を参照),
			\"次のコメント\"のリンクはページ番号の左側に表示されます."),
			
    array(    "name" => "コメントナビゲーションでの\"前のコメント\"のリンク",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_comments_next_prev_older",
            "std" => __("&laquo; Older Comments","atahualpa"),
            "type" => "text",
			"size" => "30", 
			"editable" => "yes", 
            "info" => "上のHTMLサンプルを参照してください. ページ番号を表示するように設定した場合(下を参照),
			\"前のコメント\"のリンクはページ番号の右側に表示されます."),

    array(    "name" => "コメントナビゲーションの表示位置",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_location_comments_next_prev",
            "std" => "Above and Below Comments",
            "type" => "select", 
			"options" => array("Above Comments", "Below Comments", "Above and Below Comments"),
            "info" => "次 / 前のコメントのナビゲーションの表示位置を設定します<br /><br />"),

    array(    "name" => "コメントボックスのスタイル(上)",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_next_prev_style_comments_above",
            "std" => "margin: 0 0 10px 0;\npadding: 5px 0 5px 0;",
            "type" => "textarea-large",
            "info" => "次 / 前のコメントのナビゲーションを保持するボックスが，コメントの上に表示される際のスタイルを設定します."),

    array(    "name" => "コメントボックスのスタイル(下)",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_next_prev_style_comments_below",
            "std" => "margin: 0 0 10px 0;\npadding: 5px 0 5px 0;",
            "type" => "textarea-large",
            "info" => "次 / 前のコメントのナビゲーションを保持するボックスが，コメントの下に表示される際のスタイルを設定します."),

    array(    "name" => "コメントナビゲーションでのページ番号表示",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_next_prev_comments_pagination",
            "std" => "Yes",
            "type" => "select", 
			"options" => array("Yes", "No"), 
            "info" => "通常の次 / 前のコメントのリンクの代わりに, ページ番号と次 / 前のリンクを表示させることができます.
		ここまでの\"次のコメント\"リンクと\"前のコメント\"リンクの設定は, リンクテキストに適用されます."),

);

$options3 = array(
			
    array(    "name" => "複数投稿ページでの次 / 前のページのナビゲーションの表示位置",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_location_multi_next_prev",
            "std" => "Bottom",
            "type" => "select", 
			"options" => array("Top", "Bottom", "Top and Bottom", "None"), 
            "info" => "複数投稿ページでの次 / 前のナビゲーションの表示位置を設定します.
		上(すべての投稿の上)、下(すべての投稿の下), 両方(上と下), 表示しないのいずれかに設定します."),
			
    array(    "name" => "単一投稿ページでの次 / 前のページのナビゲーションの表示位置",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_location_single_next_prev",
            "std" => "Top",
            "type" => "select", 
			"options" => array("Top", "Middle", "Bottom", "Top and Middle", "Top and Bottom", "Middle and Bottom", 
			"Top, Middle and Bottom", "None"), 
            "info" => "単一投稿ページでの次 / 前のナビゲーションの表示位置を設定します.
		上, 中(投稿とコメントとの間), 下, これらの組み合わせ, 表示しないのいずれかに設定します."),

    array(    "name" => "ナビゲーションボックスのスタイル(上)",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_next_prev_style_top",
            "std" => "margin: 0 0 10px 0;\npadding: 0 0 10px 0;\nborder-bottom: dashed 1px #cccccc;",
            "type" => "textarea-large",
            "info" => "次 / 前のナビゲーションを保持するボックスが，上に表示される際のスタイルを設定します."),

	array(    "name" => "ナビゲーションボックスのスタイル(中)",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_next_prev_style_middle",
            "std" => "margin: 10px 0 20px 0;\npadding: 10px 0 10px 0;\nborder-top: dashed 1px #cccccc;\nborder-bottom: dashed 1px #cccccc;",
            "type" => "textarea-large",
            "info" => "次 / 前のナビゲーションを保持するボックスが，中に表示される際のスタイルを設定します."),
			
    array(    "name" => "ナビゲーションボックスのスタイル(下)",
    	    "category" => "next-prev-nav",
            "id" => $shortname."_next_prev_style_bottom",
            "std" => "margin: 20px 0 0 0;\npadding: 10px 0 0 0;\nborder-top: dashed 1px #cccccc;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "次 / 前のナビゲーションを保持するボックスが，下に表示される際のスタイルを設定します."),
			
// New category: sidebars

    array(    "name" => "左側のサイドバーの表示項目",
    	    "category" => "sidebars",
			"switch" => "yes",
            "id" => $shortname."_leftcol_on",
            "std" => array ("homepage" => "on", 
								"frontpage" => "on", 
								"single" => "on", 
								"page" => "on", 
								"category" => "on", 
								"date" => "on", 
								"tag" => "on", 
								"taxonomy" => "on",
								"search" => "on", 
								"author" => "on", 
								"404" => "on", 
								"attachment" => "on", 
								"check-if-saved-once" => FALSE),
            "type" => "displayon",
			"stripslashes" => "no",
            "info" => "(*) \"Front Page\"は, WordPress 2.5以降でのみ意味を持ちます: これに該当する比較的新しいWordPressで
		ホームページとして静的な\"ページ\"を指定した場合, \"Front Page\"が実際のホームページとなり, \"Homepage\"は
		投稿(ブログ全体ではない)のホームページとなります. フロントページに静的なページが選択されなかった場合, 
		ホームページとフロントページとは同一になります.<br />
		(**) Custom Taxonomy(カスタマイズされた分類)ページ. カスタマイズされた分類ページは, デフォルトでは存在しません. 
		自力で作成するか, http://wordpress.org/extend/plugins/custom-taxonomies/のようなプラグインを利用して作成する必要があります."),

    array(    "name" => "左側のサイドバーに表示しないページ",
    	    "category" => "sidebars",
            "id" => $shortname."_left_col_pages_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "左側のサイドバーに<strong>特定の</strong>ページを表示させたくない場合は, ここにそれらのページのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>29,8,111</code><br /><br />
		ページのIDを確認するには, WordPressの管理画面 -> ページ -> <a href=\"edit-pages.php\">編集</a>で対象のページのタイトルに
		マウスをポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&post=<strong>XX</strong>\"のよう
		なURLの最後を確認します. <strong>XX</strong>がページのIDになります."),

    array(    "name" => "左側のサイドバーに表示しないカテゴリ",
    	    "category" => "sidebars",
            "id" => $shortname."_left_col_cats_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "左側のサイドバー<strong>特定の</strong>カテゴリを表示させたくない場合は, ここにそれらのカテゴリのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>13,5,87</code><br /><br />
		カテゴリのIDを確認するには, WordPressの管理画面 -> 投稿 -> <a href=\"categories.php\">カテゴリ</a>で対象のカテゴリのタイトルを
		マウスでポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&cat_ID=<strong>XX</strong>\"のような
		URLの最後を確認します. <strong>XX</strong>がカテゴリのIDになります.<br /><br />
		ノート: この設定でサイドバーのカテゴリページ(指定されたカテゴリの投稿がリストされたページ)は表示されなくなりますが, 
		\"カテゴリXXに属する投稿の単一投稿ページ\"が表示されなくなるわけではありません."), 

    array(    "name" => "左側のINNERサイドバーの表示項目",
    	    "category" => "sidebars",
            "id" => $shortname."_leftcol2_on",
            "std" => array ("check-if-saved-once" => FALSE),
            "type" => "displayon",
			"stripslashes" => "no",
            "info" => "(*) \"Front Page\"は, WordPress 2.5以降でのみ意味を持ちます: これに該当する比較的新しいWordPressで
		ホームページとして静的な\"ページ\"を指定した場合, \"Front Page\"が実際のホームページとなり, \"Homepage\"は
		投稿(ブログ全体ではない)のホームページとなります. フロントページに静的なページが選択されなかった場合, 
		ホームページとフロントページとは同一になります.<br />
		(**) Custom Taxonomy(カスタマイズされた分類)ページ. カスタマイズされた分類ページは, デフォルトでは存在しません. 
		自力で作成するか, http://wordpress.org/extend/plugins/custom-taxonomies/のようなプラグインを利用して作成する必要があります."),

    array(    "name" => "左側のINNERサイドバーに表示しないページ",
    	    "category" => "sidebars",
            "id" => $shortname."_left_col2_pages_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "左側のサイドバーに<strong>特定の</strong>ページを表示させたくない場合は, ここにそれらのページのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>29,8,111</code><br /><br />
		ページのIDを確認するには, WordPressの管理画面 -> ページ -> <a href=\"edit-pages.php\">編集</a>で対象のページのタイトルに
		マウスをポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&post=<strong>XX</strong>\"のよう
		なURLの最後を確認します. <strong>XX</strong>がページのIDになります."),

    array(    "name" => "左側のINNERサイドバーに表示しないカテゴリ",
    	    "category" => "sidebars",
            "id" => $shortname."_left_col2_cats_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "左側のサイドバー<strong>特定の</strong>カテゴリを表示させたくない場合は, ここにそれらのカテゴリのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>13,5,87</code><br /><br />
		カテゴリのIDを確認するには, WordPressの管理画面 -> 投稿 -> <a href=\"categories.php\">カテゴリ</a>で対象のカテゴリのタイトルを
		マウスでポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&cat_ID=<strong>XX</strong>\"のような
		URLの最後を確認します. <strong>XX</strong>がカテゴリのIDになります.<br /><br />
		ノート: この設定でサイドバーのカテゴリページ(指定されたカテゴリの投稿がリストされたページ)は表示されなくなりますが, 
		\"カテゴリXXに属する投稿の単一投稿ページ\"が表示されなくなるわけではありません."), 
						
	array(    "name" => "右側のサイドバーの表示項目",
    	    "category" => "sidebars",
            "id" => $shortname."_rightcol_on",
            "std" => array ("homepage" => "on", 
								"frontpage" => "on", 
								"single" => "on", 
								"page" => "on", 
								"category" => "on", 
								"date" => "on", 
								"tag" => "on", 
								"taxonomy" => "on",
								"search" => "on", 
								"author" => "on", 
								"404" => "on", 
								"attachment" => "on", 
								"check-if-saved-once" => FALSE),
            "type" => "displayon",
			"stripslashes" => "no",
            "info" => "(*) \"Front Page\"は, WordPress 2.5以降でのみ意味を持ちます: これに該当する比較的新しいWordPressで
		ホームページとして静的な\"ページ\"を指定した場合, \"Front Page\"が実際のホームページとなり, \"Homepage\"は
		投稿(ブログ全体ではない)のホームページとなります. フロントページに静的なページが選択されなかった場合, 
		ホームページとフロントページとは同一になります.<br />
		(**) Custom Taxonomy(カスタマイズされた分類)ページ. カスタマイズされた分類ページは, デフォルトでは存在しません. 
		自力で作成するか, http://wordpress.org/extend/plugins/custom-taxonomies/のようなプラグインを利用して作成する必要があります."),

    array(    "name" => "右側のサイドバーに表示しないページ",
    	    "category" => "sidebars",
            "id" => $shortname."_right_col_pages_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "右側のサイドバーに<strong>特定の</strong>ページを表示させたくない場合は, ここにそれらのページのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>29,8,111</code><br /><br />
		ページのIDを確認するには, WordPressの管理画面 -> ページ -> <a href=\"edit-pages.php\">編集</a>で対象のページのタイトルに
		マウスをポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&post=<strong>XX</strong>\"のよう
		なURLの最後を確認します. <strong>XX</strong>がページのIDになります."),

    array(    "name" => "右側のサイドバーに表示しないカテゴリ",
    	    "category" => "sidebars",
            "id" => $shortname."_right_col_cats_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "右側のサイドバー<strong>特定の</strong>カテゴリを表示させたくない場合は, ここにそれらのカテゴリのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>13,5,87</code><br /><br />
		カテゴリのIDを確認するには, WordPressの管理画面 -> 投稿 -> <a href=\"categories.php\">カテゴリ</a>で対象のカテゴリのタイトルを
		マウスでポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&cat_ID=<strong>XX</strong>\"のような
		URLの最後を確認します. <strong>XX</strong>がカテゴリのIDになります.<br /><br />
		ノート: この設定でサイドバーのカテゴリページ(指定されたカテゴリの投稿がリストされたページ)は表示されなくなりますが, 
		\"カテゴリXXに属する投稿の単一投稿ページ\"が表示されなくなるわけではありません."), 

	array(    "name" => "右側のINNERサイドバーの表示項目",
    	    "category" => "sidebars",
            "id" => $shortname."_rightcol2_on",
            "std" => array ("check-if-saved-once" => FALSE),
            "type" => "displayon",
			"stripslashes" => "no",
            "info" => "(*) \"Front Page\"は, WordPress 2.5以降でのみ意味を持ちます: これに該当する比較的新しいWordPressで
		ホームページとして静的な\"ページ\"を指定した場合, \"Front Page\"が実際のホームページとなり, \"Homepage\"は
		投稿(ブログ全体ではない)のホームページとなります. フロントページに静的なページが選択されなかった場合, 
		ホームページとフロントページとは同一になります.<br />
		(**) Custom Taxonomy(カスタマイズされた分類)ページ. カスタマイズされた分類ページは, デフォルトでは存在しません. 
		自力で作成するか, http://wordpress.org/extend/plugins/custom-taxonomies/のようなプラグインを利用して作成する必要があります."),

    array(    "name" => "右側のINNERサイドバーに表示しないページ",
    	    "category" => "sidebars",
            "id" => $shortname."_right_col2_pages_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "右側のサイドバーに<strong>特定の</strong>ページを表示させたくない場合は, ここにそれらのページのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>29,8,111</code><br /><br />
		ページのIDを確認するには, WordPressの管理画面 -> ページ -> <a href=\"edit-pages.php\">編集</a>で対象のページのタイトルに
		マウスをポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&post=<strong>XX</strong>\"のよう
		なURLの最後を確認します. <strong>XX</strong>がページのIDになります."),

    array(    "name" => "右側のINNERサイドバーに表示しないカテゴリ",
    	    "category" => "sidebars",
            "id" => $shortname."_right_col2_cats_exclude",
            "std" => "",
            "type" => "text",
			"size" => "30", 
            "info" => "右側のサイドバー<strong>特定の</strong>カテゴリを表示させたくない場合は, ここにそれらのカテゴリのIDをコンマ区切り
		で指定します.<br /><br />
		<strong>例:</strong><br /><code>13,5,87</code><br /><br />
		カテゴリのIDを確認するには, WordPressの管理画面 -> 投稿 -> <a href=\"categories.php\">カテゴリ</a>で対象のカテゴリのタイトルを
		マウスでポイントした状態で, ブラウザのステータスバー(画面最下部)に表示される\"...action=edit&cat_ID=<strong>XX</strong>\"のような
		URLの最後を確認します. <strong>XX</strong>がカテゴリのIDになります.<br /><br />
		ノート: この設定でサイドバーのカテゴリページ(指定されたカテゴリの投稿がリストされたページ)は表示されなくなりますが, 
		\"カテゴリXXに属する投稿の単一投稿ページ\"が表示されなくなるわけではありません."), 
			
    array(    "name" => "左側のサイドバーの幅",
    	    "category" => "sidebars",
            "id" => $shortname."_left_sidebar_width",
            "std" => "200",
            "type" => "text", 
			"size" => "6", 
            "info" => "左側のサイドバーの幅をピクセル単位で設定します. <strong>例:</strong> <code>165</code>"),

    array(    "name" => "左側のINNERサイドバーの幅",
    	    "category" => "sidebars",
            "id" => $shortname."_left_sidebar2_width",
            "std" => "200",
            "type" => "text", 
			"size" => "6", 
            "info" => "左側のサイドバーの幅をピクセル単位で設定します. <strong>例:</strong> <code>165</code>"),
            
    array(    "name" => "右側のサイドバーの幅",
    	    "category" => "sidebars",
            "id" => $shortname."_right_sidebar_width",
            "std" => "200",
            "type" => "text", 
			"size" => "6", 
            "info" => "右側のサイドバーの幅をピクセル単位で設定します. <strong>例:</strong> <code>220</code>"),

    array(    "name" => "右側のINNERサイドバーの幅",
    	    "category" => "sidebars",
            "id" => $shortname."_right_sidebar2_width",
            "std" => "200",
            "type" => "text", 
			"size" => "6", 
            "info" => "右側のサイドバーの幅をピクセル単位で設定します. <strong>例:</strong> <code>220</code>"),
            			
    array(    "name" => "左側のサイドバーのスタイル",
    	    "category" => "sidebars",
            "id" => $shortname."_left_sidebar_style",
            "std" => "border-right: dashed 1px #CCCCCC;\npadding: 10px 10px 10px 10px;\nbackground: #ffffff;",
            "type" => "textarea-large",
            "info" => "左側のサイドバーのスタイルを設定します. 通常, サイドバー内のすべてのコンテンツはウィジェットの中に収まるので, 
		サイドバー名のテキスト形式を指定する必要はありません. ウィジェットのスタイルの設定は別の場所で行います. メニュータブを参照してください."),

    array(    "name" => "左側のINNERサイドバーのスタイル",
    	    "category" => "sidebars",
            "id" => $shortname."_left_sidebar2_style",
            "std" => "border-right: dashed 1px #CCCCCC;\npadding: 10px 10px 10px 10px;\nbackground: #ffffff;",
            "type" => "textarea-large",
            "info" => "左側のサイドバーのスタイルを設定します. 通常, サイドバー内のすべてのコンテンツはウィジェットの中に収まるので, 
		サイドバー名のテキスト形式を指定する必要はありません. ウィジェットのスタイルの設定は別の場所で行います. メニュータブを参照してください."),
			
    array(    "name" => "右側のサイドバーのスタイル",
    	    "category" => "sidebars",
            "id" => $shortname."_right_sidebar_style",
            "std" => "border-left: dashed 1px #CCCCCC;\npadding: 10px 10px 10px 10px;\nbackground: #ffffff;",
            "type" => "textarea-large",
            "info" => "右側のサイドバーのスタイルを設定します."),

    array(    "name" => "右側のINNERサイドバーのスタイル",
    	    "category" => "sidebars",
            "id" => $shortname."_right_sidebar2_style",
            "std" => "border-left: dashed 1px #CCCCCC;\npadding: 10px 10px 10px 10px;\nbackground: #ffffff;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "右側のサイドバーのスタイルを設定します."),
            
// New category: widgets

    array(    "name" => "ウィジェットのコンテナ",
    	    "category" => "widgets",
			"switch" => "yes",
            "id" => $shortname."_widget_container",
            "std" => "margin: 0 0 15px 0;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/widget.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"ウィジェットコンテナは, \"ウィジェットタイトル\"と\"ウィジェットコンテンツ\"とを内包します. 
			いずれも独自にスタイルを設定することができます."),

    array(    "name" => "ウィジェットタイトルボックス",
    	    "category" => "widgets",
            "id" => $shortname."_widget_title_box",
            "std" => "",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/widget-title-box.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"ウィジェットタイトルボックスは, ウィジェットタイトルを内包します. テキストやカレンダー, 検索ウィジェットは, 
			不要であればタイトルを持つ必要はありません. その場合, ウィジェットコンテナにウィジェットタイトルボックスはありません."),

    array(    "name" => "ウィジェットタイトル",
    	    "category" => "widgets",
            "id" => $shortname."_widget_title",
            "std" => "font-size: 1.6em;\nfont-weight: bold;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/widget-title.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "ウィジェットタイトルのフォントを設定します."),

    array(    "name" => "ウィジェットコンテンツボックス",
    	    "category" => "widgets",
            "id" => $shortname."_widget_content",
            "std" => "",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/widget-content.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "ウィジェットコンテンツボックスは, プラグインの互換性向上を目指して
			Atahualpa 3.4から採用されました. これは, スタイル設定の柔軟性を拡張するAtahualpaの独自機能ですが, 一部のプラグインは, 
			(ウィジェット内に追加のDIVを持たない)\"デフォルト\"テーマに含まれるウィジェットと同じ構成を持っていたウィジェットに
			強く依存していたため, すべてのプラグインでうまく動作しませんでした.
			\"div.widget-container\"の代わりに, ここであなたが設定したスタイルは\"div.widget ul, div.textwidget\"に適用されます. 
			これはすべてのテキストウィジェットと, すべての番号なしリストを含むウィジェットとをカバーすることになり, 結果的に大部分の
			ウィジェットをサポートしています. サポートされていないようであれば, ブラウザでレンダリング済みのあなたのWebサイトのページ
			のソースコードを見て, どのDIV, もしくはその他のHTMLエレメントがウィジェットのコンテンツを内包しているのかを確認して, そこに
			次のようなCSSを挿入してみてください : <code>div.some-class { margin: 10px }</code>."),

    array(    "name" => "ウィジェットリストアイテム",
    	    "category" => "widgets",
            "id" => $shortname."_widget_lists",
       			"std" => array  (
       								"li-margin-left" => 0, 
       								"link-weight" => "normal", 
       								"link-padding-left" => 5, 
       								"link-border-left-width" => 7,
       								"link-color" => "666666", 
       								"link-hover-color" => "000000",  
       								"link-border-left-color" => "cccccc", 
       								"link-border-left-hover-color" => "000000"),
            "type" => "widget-list-items",
			"stripslashes" => "no",
            "info" => "<img src=\"" . $url_base . "/options/images/widget-list-items-1.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "ウィジェット内にリストされるアイテムとリンクとの設定を行います."),

    array(    "name" => "ウィジェットリストアイテム(二階層目)",
    	    "category" => "widgets",
            "id" => $shortname."_widget_lists2",
       			"std" => array  (
       								"li-margin-left" => 5, 
       								"link-weight" => "normal",
       								"link-padding-left" => 5, 
       								"link-border-left-width" => 7,
       								"link-color" => "666666", 
       								"link-hover-color" => "000000",  
       								"link-border-left-color" => "cccccc", 
       								"link-border-left-hover-color" => "000000"),
            "type" => "widget-list-items",
			"stripslashes" => "no",
            "info" => "<img src=\"" . $url_base . "/options/images/widget-list-items-2.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "ウイジェットの二階層目にリストされるアイテムとリンクとの設定を行います."),

    array(    "name" => "ウィジェットリストアイテム(三階層目以下)",
    	    "category" => "widgets",
            "id" => $shortname."_widget_lists3",
				"std" => array  (
       								"li-margin-left" => 5, 
       								"link-weight" => "normal", 
       								"link-padding-left" => 5, 
       								"link-border-left-width" => 7,
       								"link-color" => "666666", 
       								"link-hover-color" => "000000",  
       								"link-border-left-color" => "cccccc", 
       								"link-border-left-hover-color" => "000000"),
            "type" => "widget-list-items",
			"stripslashes" => "no",
            "info" => "<img src=\"" . $url_base . "/options/images/widget-list-items-3.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "ウイジェットの三階層目以下にリストされるアイテムとリンクとの設定を行います."),

    array(    "name" => "カテゴリウィジェットの表示タイプ",
    	    "category" => "widgets",
            "id" => $shortname."_category_widget_display_type",
            "std" => "inline",
            "type" => "select", 
            "options" => array("inline", "block"),
            "info" => "カテゴリウィジェットは, 単一リストアイテム内にリンクを持つテキストと持たないテキスト(\"投稿件数\")との
		両方を持ち, 階層構造を持ち, 単一行に収まらないほど長いテキストを持つ可能性がある唯一のウイジェットであるため, 
		追加の設定項目が必要とされます. 様々なブラウザに対応した最高の出力を得るには, 次のように設定してください.
		<ul><li><code>inline</code> 投稿件数を表示している場合</li>
		<li><code>block</code> 投稿件数を表示して<strong>いない</strong>場合</li></ul>"),

    array(    "name" => "選択メニューのフォントサイズの調整",
    	    "category" => "widgets",
            "id" => $shortname."_select_font_size",
            "std" => "Default",
            "type" => "select", 
            "options" => array("Default", "12px", "11px", "10px", "9px"),
			"lastoption" => "yes", 
            "info" => "<img src=\"" . $url_base . "/options/images/select-cutoff.gif\" 
		style=\"float: right; margin: 0 0 10px 10px;\">" . "<strong>Internet Explorer</strong>では, 
		一つもしくは複数の選択メニューアイテム(ここではカテゴリタイトル)が長すぎる場合, \"選択\"ドロップ
		ダウンメニューは途中で切られてしまいます.<br /><br />
		もしあなたが自分の選択メニューがサイドバーの幅に対して長すぎると感じている(IEを利用しているのであれば
		わかっている)のであれば, これを回避するために (小さな)固定ピクセルフォントサイズ, たとえば<strong>11px</strong>
		(11ピクセル)を選択メニューアイテムのフォントとして指定する必要があります. (あるいは: サイドバーの幅を広くする)"),
			
// New category: widget-areas

    array(    "name" => "カスタムウィジェットエリアの削除",
    	    	"category" => "widget-areas",
				"switch" => "yes",
            "id" => $shortname."_widget_areas_reset",
            "type" => "info",
            "info" => "1) このテーマオプション内のテキストエリアにあなたが配置した<code>&lt;?php bfa_widget_area(...) ?&gt;</code>のコードを, 削除します.
		<br />2) 削除したいウィジェットエリアを選択し, 以下のリンクをクリックします. <br />
		ノート: 関連するコード(ステップ1を参照)を削除しない限り, そのウィジェットエリアは再生成されます. <br />
<form action=\"\" method=\"\" id=\"widgetarea-form\">" . $widget_form_string . "</form>
<a style='display:block; background:#C6D9E9;width:250px;margin-top:10px; padding:5px 10px;' id='reset_widget_areas' href='#'>チェックされたウィジェットエリアの削除</a><span style='color:green;font-weight:bold;float:left;padding-left:30px' id='formstatus'></span><br />"),

    array(    "name" => "新しいウィジェットエリアの追加",
    	    	"category" => "widget-areas",
            "id" => $shortname."_widget_areas_info",
            "type" => "info",
				"lastoption" => "yes", 
            "info" => "<strong>ノート: 新たなウィジェットエリアを追加した後, <span style='color:red'>フロントエンドページを1～2回リロード</span> 
		しないと, それらが生成されたフロントエンドに現れるようになりません. また, <span style='color:red'>Wordpressの管理画面 -> 外観 -> ウィジェットを1～2回リロード</span> 
		しないと, 新たのウィジェットエリアが見えるようにならず, ウィジェットを追加できる状態にもなりません.</strong><br /><br />
		既存のウィジェットエリア(サイドバー)に加えて, ヘッダー領域や中央カラム, フッターエリアなどに, 新たなウィジェットエリアを追加することができます. 
		このページでは, その機能をどのように利用するのかのみを解説しています. 実際に新たなウィジェットエリアを追加するには, 以下のいずれかのメニュータブで
		作業を行う必要があります:
		<ul><li><a href=\"javascript: myflowers.expandit('header-tab')\">ヘッダーエリアのスタイルと編集</a>: \"ヘッダーエリアの編集\"という名前のテキストエリアにコードを追加します.</li>
		<li><a href=\"javascript: myflowers.expandit('center-tab')\">中央カラムのスタイルと編集</a>: \"中央カラムのスタイル\"という名前の最初のテキストエリア以外のテキストエリアにコードを追加します.</li>
		<li><a href=\"javascript: myflowers.expandit('footer-style-tab')\">フッターのスタイルと編集</a>: \"フッターのコンテンツ\"という名前のテキストエリアにコードを追加します.</li>
		<li>技術的には, php, header.php or footer.phpなどのAtahualpaのファイル群の一つに(下に表示されているコードを利用して)直接ウィジェットエリアのコードを書くこともできます.
		しかし, Atahualpaのバージョンをアップグレードするたびに同じ作業を行う必要があるため, これは行うべきではありません. あなたがコードを挿入したいと思う場所に対応するテーマオプションに
		ほとんどの場合テキストエリアがありますので, 実質この作業に費やされる時間のほとんどは無意味になるでしょう. 
		このテーマオプションであなたが挿入したコードはデータベースに保存され, Atahualpaのバージョンをアップグレードした際に, 自動的に引き継がれます.</li></ul>

<h3>利用方法</h3>
新たなウイジェットエリアを生成するコードは, 引数を伴ったPHPのファンクションになります:<br />
<code>&lt;?php bfa_widget_area('parameter=value&paramater=value&paramater=value'); ?&gt;</code>

<h3>最低限必要とされるパラメータ</h3>
以下が, ウイジェットエリアを生成するための, 最短かつ最も基本的な方法です.<br />
<code>&lt;?php bfa_widget_area('name=My new widget area'); ?&gt;</code><br /><br />
このケースの場合, シンプルなDIVコンテナが生成されます. あなたのWebサイトのソースコードでは, 以下のように見えます:<br />
<code>&lt;div id=\"my_new_widget_area\" class=\"bfa_widget_area\"&gt; ウイジェットがここに入ります &lt;/div&gt;</code><br />
(複数のセルを選択した場合, 代わりにテーブルが生成されます. 下を参照してください).

<h3>例:</h3>
この例では, 更に多くのパラメータを利用しています. ここでは(他のウイジェットエリアと同じように)ウイジェットエリアの幅は利用可能な幅全体となり, ウイジェットエリアセルは
4つになります(デフォルト : 1). それぞれのウイジェットエリアセルは, 独自の権限を持ったウイジェットエリアになります. それぞれのウイジェットエリアセルについて, 
アラインメントと幅を指定することができます. 更に, これらのウイジェットエリアセルにおかれるウイジェットのオープンとクローズを行うHTMLのタグを指定することもできます.<br />
<code>&lt;?php bfa_widget_area('name=My widget area&cells=4&align=1&align_2=9&align_3=7&width_4=700&before_widget=&lt;div id=\"%1\$s\" class=\"header-widget %2\$s\"&gt;&after_widget=&lt;/div&gt;'); ?&gt;</code><br /><br />
複数のセルが横並びになることが可能であるため, DIVではなくテーブルが生成されます. これをフローティングDIVで実現しようとすると, 脆弱になるだけでなく, 中に含まれるコード
以上の量のコードが必要となるでしょう.


<h3>利用できるパラメータ:</h3>
<table>
<tr>
<td class='bfa-td' colspan='2' style='border-top-style: solid'>
<strong>必須パラメータ:</strong>
</td>
</tr><tr>
<td class='bfa-td'><code>name</code></td>
<td class='bfa-td'>Wordpressの管理画面 -> 外観 -> <a href='widgets.php'>ウィジェット</a>にリストされる, すべてのセルを含むウィジェットエリアの名前
		(上部右側のドロップダウン選択メニューを参照)を設定します.<br /><br />
		<em>3つのセルを持った\"My widget area\"という名前のウイジェットエリアは, Wordpressの管理画面 -> 外観 -> ウィジェットで
		は\"My widget area 1\", \"My widget area 2\", \"My widget area 3\"と表示され, それぞれのCSS IDは
		\"my_widget_area_1\", \"my_widget_area_2\", \"my_widget_area_3\"になります. </em>
</td>
</tr><tr>
<td class='bfa-td' colspan='2' style='border-top-style: solid'>		
<strong>オプションパラメータ:</strong>
</td>
</tr><tr>
<td class='bfa-td'><code>cells</code></td>
<td class='bfa-td'>(テーブルの)セルの数を設定します. それぞれのセルが新たなウィジェットエリアとなります. デフォルト: 1</td>
</tr><tr>
<td class='bfa-td'><code>align</code></td>
<td class='bfa-td'><img src=\"" . $url_base . "/options/images/widget-area-alignment.gif\" 
		style=\"float: left; margin: 0 10px 10px 0;\">すべてのセルのデフォルトのアラインメントを設定します.<br />
		デフォルト: <code>2</code> (= 中央上). <code>1</code> = 中央, <code>2</code> = 中央上, 
		<code>3</code> = 右上, <code>4</code> = 右中央, <code>5</code> = 右下, <code>6</code> = 中央下, 
		<code>7</code> = 左下, <code>8</code> = 左中央, <code>9</code> = 左上</td>
</tr><tr>
<td class='bfa-td'><code>align_1</code>, <code>align_2</code>, <code>align_3</code> etc.</td>
<td class='bfa-td'><img src=\"" . $url_base . "/options/images/widget-area-alignment.gif\" 
		style=\"float: left; margin: 0 10px 10px 0;\">特定のウィジェットエリアのセルのアラインメントを設定します. 
		設定されていない場合, ウィジェットエリアはデフォルトの値をグローバルパラメータ<code>align</code>から取得します. 
		デフォルト値が設定されていない場合, <code>2</code> (= 中央上)になります.</td>
</tr><tr>
<td class='bfa-td'><code>width_1</code>, <code>width_2</code>, <code>width_3</code> etc.</td>	
<td class='bfa-td'>特定のウィジェットエリアのセルの幅を設定します. 設定されていない場合, ウィジェットエリアのセルはウィジェットエリアテーブル全体の残りの幅を均等に割った幅になります.</td>
</tr>
<tr>
<td class='bfa-td' colspan='2' style='border-top-style: solid'>		
<strong>特殊なオプション:</strong><br />新しいウィジェットエリアに置くウィジェットの開始/終了HTMLタグを変更したい場合にのみ, これらの設定を利用してください. 
	 デフォルトではウィジェットの開始/終了タグはサイドバーのウィジェットと同じになります. デフォルトのタグは下に表示されている通りです. <br /><br />
	<em>Note: これらのHTMLタグは, 特定のウィジェットエリアのそれぞれのウィジェットを内包することになります. 
	目的は, 設置されるウィジェットエリアに応じて異なるHTMLタグでウィジェットを内包することにあります. 設置するウィジェットエリアに応じて異なるスタイル
	を設定したいだけであれば, 通常はそのCSS IDや親(そのウィジェットが置かれるウィジェットエリア)のクラスを通じて, CSSだけで実現できます:<br /></em>
	<code>div#my_widget_area div.widget { border: solid 1px black}</code><br />
	<em>これらの開始/終了HTMLタグを利用するのは, ウィジェットやウィジェットタイトル, 特定のウィジェットエリアの前後に異なるHTMLタグを必要とする, 
	CSSだけでは十分ではない場合のみにしてください.</em>
</td>
</tr><tr>
<td class='bfa-td'><code>before_widget</code></td>
<td class='bfa-td'>このウィジェットエリアの任意のセルに置かれるウィジェットの前に入るHTML. <br />
	デフォルト:  <code>&lt;div id=\"%1\$s\" class=\"widget %2\$s\"&gt;</code><br />
	<code>%1\$s</code>と<code>%2\$s</code>は, ウィジェットが提供するそれぞれの名前に置換されます.</td>
</tr><tr>
<td class='bfa-td'><code>after_widget</code></td>
<td class='bfa-td'>このウィジェットエリアの任意のセルに置かれるウィジェットの後ろに入るHTML. <br />
	デフォルト: <code>&lt;/div&gt;</code></td>
</tr><tr>
<td class='bfa-td'><code>before_title</code></td>
<td class='bfa-td'>このウィジェットエリアの任意のセルに置かれるウィジェットのタイトルの前に入るHTML. <br />
	デフォルト: <code>&lt;div class=\"widget-title\"&gt;&lt;h3&gt;</code></td>
</tr><tr>
<td class='bfa-td'><code>after_title</code></td>
<td class='bfa-td'>このウィジェットエリアの任意のセルに置かれるウィジェットのタイトルの後ろに入るHTML. <br />
	デフォルト: <code>&lt;/h3&gt;&lt;/div&gt;</code></td>
</tr>
</table>
"),

// New category: postinfos

    array(    "name" => "ホームページのキッカー",
    	    "category" => "postinfos",
			"switch" => "yes",
            "id" => $shortname."_post_kicker_home",
            "type" => "postinfos",
            "std" => "",
            "info" => "ホームページの投稿にキッカーを表示しない場合は, 空欄にしておいてください.<br />
		<strong>例:</strong> <code>%category%</code>"),

	array(    "name" => "複数投稿ページのキッカー",
    	    "category" => "postinfos",
            "id" => $shortname."_post_kicker_multi",
            "type" => "postinfos",
            "std" => "",
            "info" => "複数投稿ページの投稿にキッカーを表示しない場合は, 空欄にしておいてください.<br />
		<strong>例:</strong> <code>%category-linked%</code>"),

	array(    "name" => "単一投稿ページのキッカー",
    	    "category" => "postinfos",
            "id" => $shortname."_post_kicker_single",
            "type" => "postinfos",
            "std" => "",
            "info" => "単一投稿ページの投稿にキッカーを表示しない場合は, 空欄にしておいてください.<br />
		<strong>例:</strong> <code>%category-linked%</code>"),

	array(    "name" => "\"ページ\"ページのキッカー",
    	    "category" => "postinfos",
            "id" => $shortname."_post_kicker_page",
            "type" => "postinfos",
            "std" => "",
            "info" => "\"ページ\"ページにキッカーを表示しない場合は, 空欄にしておいてください.<br />
		<em>ノート: \"ページ\"ページは, カテゴリやタグを持っていません</em>"),

	array(    "name" => "ホームページのバイライン",
    	    "category" => "postinfos",
            "id" => $shortname."_post_byline_home",
            "type" => "postinfos",
            "std" => "",
            "info" => "ホームページの投稿にバイラインを表示しない場合は, 空欄にしておいてください.<br />
		<strong>例:</strong> <code>By %author%, on %date('<i>F jS, Y</i>')%</code>"),

	array(    "name" => "複数投稿ページのバイライン",
    	    "category" => "postinfos",
            "id" => $shortname."_post_byline_multi",
            "type" => "postinfos",
            "std" => "",
            "info" => "複数投稿ページの投稿にバイラインを表示しない場合は, 空欄にしておいてください.<br />
		<strong>例:</strong> <code>By %author%, on %date('<i>F jS, Y</i>')%</code>"),

	array(    "name" => "単一投稿ページのバイライン",
    	    "category" => "postinfos",
            "id" => $shortname."_post_byline_single",
            "type" => "postinfos",
            "std" => "",
            "info" => "単一投稿ページの投稿にバイラインを表示しない場合は, 空欄にしておいてください.<br />
		<strong>例:</strong> <code>By %author%, on %date('<i>F jS, Y</i>')%</code>"),

	array(    "name" => "\"ページ\"ページのバイライン",
    	    "category" => "postinfos",
            "id" => $shortname."_post_byline_page",
            "type" => "postinfos",
            "std" => "",
            "info" => "\"ページ\"ページにバイラインを表示しない場合は, 空欄にしておいてください.
		<em>ノート: \"ページ\"ページは, カテゴリやタグを持っていません</em>"),

	array(    "name" => "ホームページのフッター",
    	    "category" => "postinfos",
            "id" => $shortname."_post_footer_home",
            "type" => "postinfos",
            "std" => "%date('F jS, Y')% | %tags-linked('" . __('Tags: ','atahualpa') . "', ', ', ' | ')% " . 
__('Category:','atahualpa') . " %categories-linked(', ')% | %comments('" . __('Leave a comment','atahualpa') . 
"', '" . __('One comment','atahualpa') . "', '" . __('% comments','atahualpa') . "', '" . __('Comments are closed','atahualpa') . 
"')% %edit(' | ', '" . __('Edit this post','atahualpa') . "', '')%",
            "info" => "ホームページの投稿にフッターを表示しない場合は, 空欄にしておいてください.<br /><strong>例:</strong> 
			<code>%tags-linked('<i>&lt;strong&gt;Tags:&lt;/strong&gt; </i>', '<i>, </i>', '<i> - </i>')% 
			&lt;strong&gt;Categories:&lt;/strong&gt; %categories-linked('<i>, </i>')%&lt;br /&gt;
			%comments('<i>Leave a comment</i>', '<i>One comment so far</i>', '<i>% comments - be the next!</i>', 
			'<i>Comments are closed</i>')% %edit(' | ', 'Edit', '')%</code>"),

	array(    "name" => "複数投稿ページのフッター",
    	    "category" => "postinfos",
            "id" => $shortname."_post_footer_multi",
            "type" => "postinfos",
            "std" => "%date('F jS, Y')% | %tags-linked('" . __('Tags: ','atahualpa') . "', ', ', ' | ')% " . 
__('Category:','atahualpa') . " %categories-linked(', ')% | %comments('" . __('Leave a comment','atahualpa') . 
"', '" . __('One comment','atahualpa') . "', '" . __('% comments','atahualpa') . "', '" . __('Comments are closed','atahualpa') . 
"')% %edit(' | ', '" . __('Edit this post','atahualpa') . "', '')%",
            "info" => "複数投稿ページの投稿にフッターを表示しない場合は, 空欄にしておいてください.<br /><strong>例:</strong> 
			<code>%tags-linked('<i>&lt;strong&gt;Tags:&lt;/strong&gt; </i>', '<i>, </i>', '<i> - </i>')% &lt;strong&gt;
			Categories:&lt;/strong&gt; %categories-linked('<i>, </i>')%&lt;br /&gt;%comments('<i>Leave a comment</i>', 
			'<i>One comment so far</i>', '<i>% comments - be the next!</i>', '<i>Comments are closed</i>')% %edit(' | ', 'Edit', '')%</code>"),

	array(    "name" => "単一投稿ページのフッター",
    	    "category" => "postinfos",
            "id" => $shortname."_post_footer_single",
            "type" => "postinfos",
            "std" => "%date('F jS, Y')% | %tags-linked('" . __('Tags: ','atahualpa') . "', ', ', ' | ')% " . 
__('Category:','atahualpa') . " %categories-linked(', ')% %edit(' | ', '" . __('Edit this post','atahualpa') . "', '')%",
            "info" => "単一投稿ページの投稿にフッターを表示しない場合は, 空欄にしておいてください.<br /><strong>例:</strong> 
			<code>%tags-linked('<i>&lt;strong&gt;Tags:&lt;/strong&gt; </i>', '<i>, </i>', '<i> - </i>')% &lt;strong&gt;
			Categories:&lt;/strong&gt; %categories-linked('<i>, </i>')% | &lt;a href=\"#comments\"&gt;Skip to comments&lt;/a&gt; %edit(' | ', 'Edit', '')%</code>"),

	array(    "name" => "\"ページ\"ページのフッター",
    	    "category" => "postinfos",
            "id" => $shortname."_post_footer_page",
            "type" => "postinfos",
            "std" => "",
			"lastoption" => "yes", 
            "info" => "\"ページ\"ページにバイラインを表示しない場合は, 空欄にしておいてください.<br />
		<em>ノート: \"ページ\"ページは, カテゴリやタグを持っていません</em>"),

// New category: posts

    array(    "name" => "投稿のコンテナ",
    	    "category" => "posts",
			"switch" => "yes",
            "id" => $shortname."_post_container_style",
            "std" => "margin: 0 0 30px 0;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-container.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿/ページ全体を保持する<strong>コンテナ</strong>のスタイルを設定します."),

    array(    "name" => "先頭に固定表示される投稿のコンテナ",
    	    "category" => "posts",
            "id" => $shortname."_post_container_sticky_style",
            "std" => "background: #eee url(" . $url_base .
            "/images/sticky.gif) 99% 5% no-repeat;\nborder: dashed 1px #cccccc;\npadding: 10px;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-container.gif\"
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿が<strong>先頭に固定表示される</strong>ように設定されている場合の
			<strong>コンテナ</strong>のスタイルを追加設定します. WordPress 2.7以降でのみ有効です. 
			WordPress 2.7の場合, 投稿を<strong>先頭に固定表示される</strong>ように設定することで, ホームページのトップに常に表示されるようになります."),

    array(    "name" => "キッカーボックス",
    	    "category" => "posts",
            "id" => $shortname."_post_kicker_style",
            "std" => "margin: 0 0 5px 0;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-kicker.gif\"
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿/ページの\"キッカー\"を保持する<strong>ボックス</strong>のスタイルを設定します."),

    array(    "name" => "キッカーボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_kicker_style_links",
            "std" => "color: #000000;\ntext-decoration: none;\ntext-transform: uppercase;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-kicker-links.gif\"
			style=\"float: right; margin: 0 0 10px 10px;\">" . "キッカーボックス内の<strong>リンク</strong>のスタイルを設定します."),			

	array(    "name" => "ポイント時のキッカーボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_kicker_style_links_hover",
            "std" => "color: #cc0000;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-kicker-links-hover.gif\"
			style=\"float: right; margin: 0 0 10px 10px;\">" . "キッカーボックス内の<strong>リンク</strong>が
			<strong>ポイント</strong>状態にあるときのスタイルを設定します."),			
			
    array(    "name" => "ヘッドラインボックス",
    	    "category" => "posts",
            "id" => $shortname."_post_headline_style",
            "std" => "",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-headline.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿/ページのタイトルを保持する<strong>ボックス</strong>のスタイルを設定します. 
			その中のテキスト(= 投稿/ページのタイトル)のスタイルは, 次のセクションで設定します."),

    array(    "name" => "ヘッドラインボックスのテキスト",
    	    "category" => "posts",
            "id" => $shortname."_post_headline_style_text",
            "std" => "padding: 0;\nmargin: 0;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-headline-text.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "<strong>投稿/ページのタイトルがリンクではなく</strong>, 
			通常のテキストである場合(=単一投稿ページと\"ページ\"ページ)のスタイルを設定します."),
			
    array(    "name" => "ヘッドラインボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_headline_style_links",
            "std" => "color: #666666;\ntext-decoration: none;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-headline-links.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "<strong>投稿/ページのタイトルがリンクである</strong>
			(= ホームやアーカイブ, カテゴリ, タグ, 検索などの複数投稿ページ)である場合のスタイルを設定します. 
			\"ページ\"ページのタイトルは通常リンクではありませんが, WordPressの検索機能をプラグインで強化した場合などに, 
			リンクになる可能性があります."),			

	array(    "name" => "ポイント時のヘッドラインボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_headline_style_links_hover",
            "std" => "color: #000000;\ntext-decoration: none;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/post-headline-links-hover.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "<strong>投稿/ページのタイトル</strong>がリンクである場合, 
			それらが<strong>ポイント</strong>状態にあるときのスタイルを設定します."),			

    array(    "name" => "バイラインボックス",
    	    "category" => "posts",
            "id" => $shortname."_post_byline_style",
            "type" => "textarea-large",
            "std" => "margin: 5px 0 10px 0;",
            "info" => "<img src=\"" . $url_base . "/options/images/post-byline.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿/ページのバイラインを保持する<strong>ボックス</strong>と, 
			バイライン内のリンクを除く<strong>テキスト</strong>のスタイルを設定します."),

	array(    "name" => "バイラインボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_byline_style_links",
            "type" => "textarea-large",
            "std" => "",
            "info" => "<img src=\"" . $url_base . "/options/images/post-byline-links.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "バイラインボックス内の<strong>リンク</strong>のスタイルを設定します."),

	array(    "name" => "ポイント時のバイラインボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_byline_style_links_hover",
            "type" => "textarea-large",
            "std" => "",
            "info" => "<img src=\"" . $url_base . "/options/images/post-byline-links-hover.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "バイラインボックス内の<strong>リンク</strong>が<strong>ポイント</strong>
			状態にあるときのスタイルを設定します."),

    array(    "name" => "本体ボックス",
    	    "category" => "posts",
            "id" => $shortname."_post_bodycopy_style",
            "type" => "textarea-large",
            "std" => "",
            "info" => "<img src=\"" . $url_base . "/options/images/post-body.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿/ページのメインテキスト(= \"ボディコピー\")を保持する<strong>ボックス</strong>
			のスタイルを設定します. 投稿/ページのメインテキストボックス内のテキストとリンクについては, メインタブの\"本体, リンク, テキスト\"で設定できます."),
		
	array(    "name" => "フッターボックス",
    	    "category" => "posts",
            "id" => $shortname."_post_footer_style",
            "type" => "textarea-large",
            "std" => "margin: 0;\npadding: 5px;\nbackground: #eeeeee;\ncolor: #666;\nline-height: 18px;",
            "info" => "<img src=\"" . $url_base . "/options/images/post-footer.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "投稿/ページのフッターを保持する<strong>ボックス</strong>と, 
			フッター内のリンクを除く<strong>テキスト</strong>のスタイルを設定します."),

	array(    "name" => "フッターボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_footer_style_links",
            "type" => "textarea-large",
            "std" => "color: #333;\nfont-weight: normal;\ntext-decoration: none;",
            "info" => "<img src=\"" . $url_base . "/options/images/post-footer-links.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "フッターボックス内の<strong>リンク</strong>のスタイルを設定します."),

	array(    "name" => "ポイント時のフッターボックスのリンク",
    	    "category" => "posts",
            "id" => $shortname."_post_footer_style_links_hover",
            "type" => "textarea-large",
            "std" => "color: #333;\nfont-weight: normal;\ntext-decoration: underline;",
			"lastoption" => "yes", 
            "info" => "<img src=\"" . $url_base . "/options/images/post-footer-links-hover.gif\" 
			style=\"float: right; margin: 0 0 10px 10px;\">" . "フッターボックス内の<strong>リンク</strong>が<strong>ポイント</strong>
			状態にあるときのスタイルを設定します."),

			
// New category: posts-or-excerpts

    array(    "name" => "抜粋の長さ",
    	    "category" => "posts-or-excerpts",
			"switch" => "yes",
            "id" => $shortname."_excerpt_length",
            "type" => "text",
            "size" => 6,
            "std" => 55,
            "info" => "抜粋の長さ(= ワード数)を設定します."),

     array(    "name" => "除外しないタグ",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_dont_strip_excerpts",
            "type" => "text",
            "size" => 40,
            "std" => "<p>",
            "info" => "デフォルトでは, WordPressは&lt;p&gt;を除く大部分のHTMLタグを要約から除外します. WordPressに除外させたくないHTMLタグ
		がある場合は, そのタグをここで設定します. 開始タグのみを, スペースやコンマを入れないで入力してください. <br /><br />
		<strong>例:</strong><br /><br />
		<code>&lt;p>&lt;a>&lt;span>&lt;em></code><br />と設定すると, \"抜粋から &lt;p&gt;, &lt;/p&gt;, &lt;a href=\"...\">, &lt;/a&gt;, 
		&lt;span class=\"...\"&gt;, &lt;/span&gt;, &lt;em&gt; and &lt;/em&gt; これらのタグを除外しないという意味になります\"."),   
            
    array(    "name" => "\"続きを読む...\"のカスタマイズ",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_custom_read_more",
            "type" => "textarea-large",
            "std" => "[...]",
            "info" => "デフォルトでは, WordPressは抜粋の最後に省略を意味する<code>[...]</code>を追加します. これをHTMLとPHPを利用してカスタマイズできます. <br /><br />
		<strong>例</strong><br /><br />
	            <code>&lt;p&gt;&lt;a href=\"%permalink%\"&gt;%title%&lt;/a&gt;の続きを読む&lt;/p&gt;</code><br /><br />
	            <code>%permalink%</code>は投稿のURLに置換されます<br />
	            <code>%title%</code>は投稿のタイトルに置換されます"),
                
    array(    "name" => "ホームページでの投稿/要約の表示",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_excerpts_home",
            "type" => "select",
            "std" => "Full Posts",
            "options" => array("Only Excerpts", "Full Posts"),
            "info" => "ホームページで, 完全な投稿と要約のどちらを表示するかを設定します."),

    array(    "name" => "ホームページの最初のX個の投稿を完全な投稿として表示する",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_full_posts_homepage",
            "type" => "select",
            "std" => 0,
            "options" => array(0,1,2,3,4,5,6,7,8,9,10),
            "info" => "ここで数値を設定し, 上のオプションで\"Only Excerpts\"を設定した場合, 最初のX個の投稿については, 完全な
        	状態でホームページのトップに表示され, それ以降は要約が表示されるようになります."),
			
    array(    "name" => "カテゴリページでの投稿/要約の表示",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_excerpts_category",
            "type" => "select",
            "std" => "Only Excerpts",
            "options" => array("Only Excerpts", "Full Posts"),
            "info" => "カテゴリのページで, 完全な投稿と要約のどちらを表示するかを設定します."),
            
    array(    "name" => "アーカイブページでの投稿/要約の表示",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_excerpts_archive",
            "type" => "select",
            "std" => "Only Excerpts",
            "options" => array("Only Excerpts", "Full Posts"),
            "info" => "(日付ベースの)アーカイブのページで, 完全な投稿と要約のどちらを表示するかを設定します."),

    array(    "name" => "タグページでの投稿/要約の表示",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_excerpts_tag",
            "type" => "select",
            "std" => "Only Excerpts",
            "options" => array("Only Excerpts", "Full Posts"),
            "info" => "タグのページで, 完全な投稿と要約のどちらを表示するかを設定します."),
            
    array(    "name" => "検索結果ページでの投稿/要約の表示",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_excerpts_search",
            "type" => "select",
            "std" => "Only Excerpts",
            "options" => array("Only Excerpts", "Full Posts"),
            "info" => "検索結果のページで, 完全な投稿と要約のどちらを表示するかを設定します."),

    array(    "name" => "著者ページでの投稿/要約の表示",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_excerpts_author",
            "type" => "select",
            "std" => "Only Excerpts",
            "options" => array("Only Excerpts", "Full Posts"),
			"lastoption" => "yes", 
            "info" => "著者のページで, 完全な投稿と要約のどちらを表示するかを設定します."),

// New category: posts-or-excerpts

    array(    "name" => "投稿のサムネイルの幅",
    	    "category" => "post-thumbnails",
			"switch" => "yes",
            "id" => $shortname."_post_thumbnail_width",
            "type" => "text",
            "size" => 6,
            "std" => 150,
            "info" => "投稿のサムネイルの幅をピクセル単位で指定します.<br><br><span style='color:red'>ノート: 投稿のサムネイルは,
			抜粋のみを表示するように設定された複数投稿ページにのみ表示されます.
			メニュータブの'抜粋の設定'を参照してください.</span>"),

    array(    "name" => "投稿のサムネイルの高さ",
    	    "category" => "post-thumbnails",
            "id" => $shortname."_post_thumbnail_height",
            "type" => "text",
            "size" => 6,
            "std" => 150,
            "info" => "投稿のサムネイルの高さをピクセル単位で指定ます."),

    array(    "name" => "投稿のサムネイルでのトリミング",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_post_thumbnail_crop",
            "type" => "select",
            "std" => "No",
            "options" => array("Yes", "No"),
            "info" => "例: オリジナルのイメージサイズが600x400だったとします. そして上の設定が150/150だったとします. この場合, サムネイルのサイズは以下の通りになります:
			<ul><li>ここで'Yes'と設定した場合, 150x150 (トリミングする)</li>
			<li>ここで'No'と設定した場合, 150x100 (トリミングしない)</li></ul>
			トリミングをすると, 投稿のサムネイルのサイズがすべて同一になりますが, イメージのどこかが欠けてしまいます(イメージが正方形でない場合). "),

    array(    "name" => "投稿のサムネイルのCSS",
    	    "category" => "posts-or-excerpts",
            "id" => $shortname."_post_thumbnail_css",
            "type" => "textarea-large",
            "std" => "float: left;\nborder: 0;\npadding: 0;\nbackground: none;\nmargin: 0 10px 5px 0;\n",
			"lastoption" => "yes", 
            "info" => "投稿のサムネイルのスタイルを設定します. この設定は投稿の'bodycopy'の中の, 抜粋の第一パラグラフの直前に置かれます:<br />
			&lt;div class='post-bodycopy'&gt;<br />&nbsp;&nbsp;&nbsp;<strong>&lt;img ここに投稿のサムネイル class='wp-post-image' /&gt;</strong><br />&nbsp;&nbsp;&nbsp;&lt;p&gt;ここから投稿の抜粋が開始...&lt;/p&gt;<br />&lt;/div&gt;"),

			
// New category: more-tag

    array(    "name" => "続きを読む",
    	    "category" => "more-tag",
			"switch" => "yes",
           "id" => $shortname."_more_tag",
            "std" => __("Continue reading %post-title%","atahualpa"),
            "type" => "text",
			"size" => "30", 
			"editable" => "yes",
			"lastoption" => "yes", 
            "info" => "\"続きを読む\"のテキストをここで設定します. ここで設定したテキストは, 手でこのタグを投稿に挿入した場合, ボタン
		(下の画像参照)を利用して挿入した場合を問わず, 投稿の中で<code>&lt;!--more--&gt;</code>を挿入したすべての個所で表示
		されるようになります. この方法は, 投稿の要約を生成する手段としては, 投稿の表示タイプを\"要約\"に設定する(メニュータブの
		\"要約の設定\"を参照)よりも, より洗練された手段です. <br /><br />
		投稿もしくはページに<code>&lt;!--more--&gt;</code>を挿入すると, そのタグの前のテキストのみが複数投稿ページに表示され, 
		全体は単一投稿ページに表示されるようになります. <br /><br />
		\"続きを読む\"のテキストに投稿名を含めたい場合は, <code>%post-title%</code>を入れてください.<br /><br />
		例:<br /> <code>\"&lt;strong&gt;%post-title%&lt/strong&gt;\" の続きを読む&amp;raquo;</code><br /><br />
		単一引用符と二重引用符, HTMLが利用できます. 例:<ul>
		<li><code>&lt;br /&gt;</code>でラインブレークが入ります</li>
			<li><code>&lt;strong&gt; ... &lt;/strong&gt;</code>でテキストが<strong>ボールド</strong>になります</li>
			<li><code>&lt;em&gt; ... &lt;/em&gt;</code>でテキストが<em>イタリック</em>になります</li>
			<li><code>&amp;nbsp;</code>でノンブレークスペースが入ります</li>
			<li><code>&amp;raquo;</code>で右二重ギュメが入ります<span style=\"font-size: 25px\">&raquo;</span></li>
			<li><code>&amp;laquo;</code>で左二重ギュメが入ります<span style=\"font-size: 25px\">&laquo;</span></li>
			<li><code>&amp;rsaquo;</code>で右一重ギュメが入ります<span style=\"font-size: 25px\">&rsaquo;</span></li>
			<li><code>&amp;lsaquo;</code>で左一重ギュメが入ります<span style=\"font-size: 25px\">&lsaquo;</span></li>
			<li><code>&amp;rarr;</code>で右矢印が入ります<span style=\"font-size: 25px\">&rarr;</span></li>
			<li><code>&amp;larr;</code>で左矢印が入ります<span style=\"font-size: 25px\">&larr;</span></li></ul>
			WordPressのエディタで\"続きを読む\"タグを投稿もしくはページに挿入するボタンです. 
			概観は, ビジュアルモードになっているのかHTMLモードになっているのかで変わります.<br /><br >" .
			"<img src=\"" . $url_base . "/options/images/readmore1.gif\" /><br /><br />
			<img src=\"" . $url_base . "/options/images/readmore2.gif\" />"),
 
// New category: comments
                                                                
    array(    "name" => "著者コメントのハイライト",
    	    "category" => "comments",
			"switch" => "yes",
            "id" => $shortname."_author_highlight",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "著者(ブログオーナー)のコメントに異なる背景色にするかどうかを設定します."),

    array(    "name" => "ハイライトされた著者コメントの色",
    	    "category" => "comments",
           "id" => $shortname."_author_highlight_color",
            "std" => "ffecec",
            "type" => "text",
            "info" => "一つ上のオプションでYesを選択した場合, 著者コメントの背景色をここで設定します."),

    array(    "name" => "2層目以下の著者コメントの枠線色",
    	    "category" => "comments",
           "id" => $shortname."_author_highlight_border_color",
            "std" => "ffbfbf",
            "type" => "text",
            "info" => "一つ上のオプションでYesを選択した場合, 2階層目以下 = 他のコメントへの直接の返信となる
		著者のコメントの枠線の色を設定します."),
			
    array(    "name" => "通常のコメント背景色",
    	    "category" => "comments",
           "id" => $shortname."_comment_background_color",
            "std" => "ffffff",
            "type" => "text",
            "info" => "コメントの背景色を設定します."),

    array(    "name" => "偶数番目のコメントの背景色",
    	    "category" => "comments",
           "id" => $shortname."_comment_alt_background_color",
            "std" => "eeeeee",
            "type" => "text",
            "info" => "偶数番目のコメントの背景色を設定します. すべてのコメントの背景色を統一したい場合は, 
		一つ上のオプションと同じ色を設定します."),

    array(    "name" => "コメント間のボーダー",
    	    "category" => "comments",
           "id" => $shortname."_comment_border",
            "std" => "dotted 1px #cccccc",
            "type" => "text",
            "info" => "各コメントを区切るボーダーのスタイルを設定します. セミコロンは利用しないでください."),

    array(    "name" => "コメント作成者名のフォントサイズ",
    	    "category" => "comments",
            "id" => $shortname."_comment_author_size",
            "type" => "select",
            "std" => "110%",
            "options" => array("100%", "105%", "110%", "115%", "120%", "125%", "130%", "135%", "140%", "145%", "150%"),
            "info" => "コメント作成者名のフォントサイズを, ベースフォントサイズとの比率で設定します."),

    array(    "name" => "コメント返信リンクのテキスト",
    	    "category" => "comments",
           "id" => $shortname."_comment_reply_link_text",
            "std" => __(" &middot; Reply", "atahualpa"),
            "type" => "text",
            "editable" => "yes",
            "info" => "各コメントの\"返信\"リンクのテキストを設定します."),

    array(    "name" => "コメント編集リンクのテキスト",
    	    "category" => "comments",
           "id" => $shortname."_comment_edit_link_text",
            "std" => __(" &middot; Edit", "atahualpa"),
            "type" => "text",
            "editable" => "yes",
            "info" => "各コメントの\"編集\"リンクのテキストを設定します. コメントの編集許可を持っているユーザに対してのみ表示されます."),

    array(    "name" => "コメント承認待ち時のテキスト",
    	    "category" => "comments",
           "id" => $shortname."_comment_moderation_text",
            "std" => __("Your comment is awaiting moderation.", "atahualpa"),
            "type" => "text",
            "editable" => "yes",
            "info" => "コメント更改前にモデレートする設定になっている場合に, コメント投稿後に表示されるテキストを設定します."),

    array(    "name" => "コメントクローズ時のテキスト",
    	    "category" => "comments",
           "id" => $shortname."_comments_are_closed_text",
            "std" => __("<p>Comments are closed.</p>", "atahualpa"),
            "type" => "text",
            "editable" => "yes",
            "info" => "投稿もしくはページに対するコメントをクローズしていない場合に, 当該投稿もしくはページの下に表示されるテキストを設定します."),

    array(    "name" => "\"ページ\"ページでのコメントの許可",
    	    "category" => "comments",
            "id" => $shortname."_comments_on_pages",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "投稿ページだけでなく, \"ページ\"ページにもコメントフォーム(と, あればコメント)を表示する場合は, Yesに設定します."),

    array(    "name" => "トラックバック / ピンとコメントとの切り離し",
    	    "category" => "comments",
            "id" => $shortname."_separate_trackbacks",
            "type" => "select",
            "std" => "No",
            "options" => array("Yes", "No"),
            "info" => "WordPress 2.6以前のための設定: コメント, トラックバック, ピンを来た順番で表示するか, トラックバックとピン
        		とをまとめてコメントの下に表示するかを設定します.<br /><br />
				<em>ノート: この機能はAtahualpaの独自機能とはうまく協調して動作しますが, 
				<a href=\"http://wordpress.org/extend/plugins/paged-comments/\">Paged Comments</a>プラグインを利用している場合, 
				もしくは WordPress 2.7を利用している場合は, うまく動作しません</em>"),	

    array(    "name" => "アバターのサイズ",
    	    "category" => "comments",
           "id" => $shortname."_avatar_size",
            "type" => "select",
            "std" => "55",
            "options" => array("0", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", "70", "75", "80"),
            "info" => "アバターのサイズをピクセル単位で設定します. 55 は 55 x 55 ピクセルという意味になります
        		(アバターを表示しない場合は, 0を選択してください(利用しているWordPressのバージョンでアバターがビルトインでサポート
        		されている場合は, WordPressの管理画面で無効にしてください)."),

    array(    "name" => "アバターのスタイル",
    	    "category" => "comments",
           "id" => $shortname."_avatar_style",
            "std" => "margin: 0 8px 1px 0;\npadding: 3px;\nborder: solid 1px #ddd;\nbackground-color: #f3f3f3;\n-moz-border-radius: 3px;\n-khtml-border-radius: 3px;\n-webkit-border-radius: 3px;\nborder-radius: 3px;",
            "type" => "textarea-large",
            "info" => "アバターのスタイルを設定します. \"radius\"を枠線に設定するとFirefoxやSafariで角が丸くなります."), 

    array(    "name" => "XHTMLタグの表示",
    	    "category" => "comments",
           "id" => $shortname."_show_xhtml_tags",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "コメントフォームの上に\"これらのHTMLタグが利用可能です\"と表示するかどうかを設定します."),			

    array(    "name" => "コメントフォームのスタイル",
    	    "category" => "comments",
           "id" => $shortname."_comment_form_style",
            "std" => "margin: 25px 0;\npadding: 25px;\nbackground: #eee;\n-moz-border-radius: 8px;\n-khtml-border-radius: 8px;\n-webkit-border-radius: 8px;\nborder-radius: 8px;",
            "type" => "textarea-large",
            "info" => "コメントフォームエリア = 名前, 電子メール, Webサイトの入力フィールド, コメントテキストエリアと
        		送信ボタンを保持するボックスのスタイルを設定します."), 
			
    array(    "name" => "送信ボタンのスタイル",
    	    "category" => "comments",
           "id" => $shortname."_submit_button_style",
            "std" => "padding: 4px 10px 4px 10px;\nfont-size: 1.2em;\nline-height: 1.5em;\nheight: 36px;",
            "type" => "textarea-large",
            "info" => "コメント送信ボタンのスタイルを設定します. 例: マージンを設定して表示位置を動かす. 
        	ここは, <strong>コメント</strong>送信ボタンのためのセクションです. 追加で, デフォルトのスタイルも適用されます.
        	デフォルトのスタイルについては, メニュータブの\"フォーム\"の中のオプションの\"送信ボタンの通常時のスタイル\"
        	と\"送信ボタンのポイント時のスタイル\"を参照してください."), 
			
    array(    "name" => "コメントの表示順",
    	    "category" => "comments",
            "id" => $shortname."_comment_display_order",
            "type" => "select",
            "std" => "Oldest on top",
            "options" => array("Oldest on top", "Newest on top"),
			"lastoption" => "yes", 
            "info" => "Wordpress 2.6以前のための設定: コメントの並び方を逆にしたい場合は, \"Newest on top\"を選択してください.
				WordPress 2.7以降では, WordPressの管理画面 -> 設定 -> ディスカッションでこの設定を行うことができます."),	
			
// New category: footer-style (don't name this "footer", Wordpress already uses that for their own footer in the admin area)

    array(    "name" => "フッターのスタイル",
    	    "category" => "footer-style",
			"switch" => "yes",
           "id" => $shortname."_footer_style",
            "std" => "background-color: #ffffff;\nborder-top: dashed 1px #cccccc;\npadding: 10px;
text-align: center;\ncolor: #777777;\nfont-size: 95%;",
            "type" => "textarea-large",
            "info" => "フッターボックスとその中のテキストのスタイルを設定します."), 

    array(    "name" => "フッターのリンクのスタイル",
    	    "category" => "footer-style",
           "id" => $shortname."_footer_style_links",
            "std" => "text-decoration: none;\ncolor: #777777;\nfont-weight: normal;",
            "type" => "textarea-large",
            "info" => "フッター内のリンクのスタイルを設定します."), 

    array(    "name" => "フッターのリンクのポイント時のスタイル",
    	    "category" => "footer-style",
           "id" => $shortname."_footer_style_links_hover",
            "std" => "text-decoration: none;\ncolor: #777777;\nfont-weight: normal;",
            "type" => "textarea-large",
            "info" => "フッター内のリンクがポイントされた際のスタイルの設定."), 

    array(    "name" => "フッターのコンテンツ",
    	    "category" => "footer-style",
           "id" => $shortname."_footer_style_content",
            "std" => __("Copyright &copy; %current-year% %home% - All Rights Reserved","atahualpa"),
            "type" => "textarea-large",
			"editable" => "yes", 
            "info" => "フッターエリアのコンテンツを設定します. PHP(WordPressの場合, WPMUは除く)と(X)HTML, 以下のプレースホルダを利用できます.
			<ul><li><code>%current-year%</code> 現在の年を表示します.</li>
			<li><code>%page-XX%</code> 特定のページへの完全なリンクを表示します. XXをページIDに置き換えてください.</li>
			<li><code>%home%</code> ホームページへの完全なリンクを表示します.</li>
			<li><code>%loginout%</code> 完全なログイン/ログアウトのリンクを表示します.</li>
			<li><code>%admin%</code> 管理者画面への完全なリンクを表示します(ログインしているユーザにのみ表示).</li>
			<li><code>%register%</code> 完全な登録リンクを表示します.</li>
			<li><code>%rss%</code> RSSフィードのURL(のみ)を表示します. 完全なリンクではなく, URLのみになります. 
			完全なリンクを表示したい場合には, <code>&lt;a href=\"%rss%\" rel=\"nofollow\"&gt;Posts Feed&lt;/a&gt;</code>
			このようなコードを利用してください.</li>
			<li><code>%comments-rss%</code> コメントRSSフィードのURL(のみ)を表示します. 完全なリンクではなく, URLのみになります. 
			完全なリンクを表示したい場合は, <code>&lt;a href=\"%comments-rss%\" rel=\"nofollow\"&gt;Comments Feed&lt;/a&gt;</code>
			このようなコードを利用してください(BFAのSEOオプションにある\"Nofollow RSS\"は, ここでは機能しません. 例示されているよう
			に, nofollowは手で挿入する必要があります).</li>
			<li>HTMLでは, <span style=\"font-size:24px\">&copy;</span> を表示するには <code>&amp;copy;</code>というコードを, 
			<span style=\"font-size:24px\">&trade;</span> を表示するには <code>&amp;trade;</code> というコードを,
			<span style=\"font-size:24px\">&reg;</span> を表示するには <code>&amp;reg;</code> というコードを挿入してください.</li></ul>"), 

	array(    "name" => "ショートページでのフッターの固定化",
    	    "category" => "footer-style",
            "id" => $shortname."_sticky_layout_footer",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes"),
            "info" => "ページがブラウザの表示領域よりも短い場合に, フッターを\"固定化\"するかどうかを設定します."),
			
    array(    "name" => "クエリ数と所要時間の表示",
    	    "category" => "footer-style",
            "id" => $shortname."_footer_show_queries",
            "type" => "select",
            "std" => "No",
            "options" => array("No", "Yes - visible", "Yes - in source code"),
			"lastoption" => "yes", 
            "info" => "任意のページのデータベースクエリの数とレンダリング所要時間とを, 各ページの最下部に表示するかどうかを
        		設定します. 特定の設定やプラグインがページをレンダリングする時間に与える影響を確認する際に役に立ちます."),

// New category: tables

    array(    "name" => "テーブルのスタイル",
    	    "category" => "tables",
			"switch" => "yes",
            "id" => $shortname."_table",
            "std" => "border-collapse: collapse;\nmargin: 10px 0;",
            "type" => "textarea-large",
            "info" => "テーブル全体のスタイルを設定します <code>&lt;table&gt;</code> ... <code>&lt;/table&gt;</code>"),
			
    array(    "name" => "テーブルキャプションのスタイル",
    	    "category" => "tables",
            "id" => $shortname."_table_caption",
            "std" => "background: #eeeeee;\nborder: #999999;\npadding: 4px 8px;\ncolor: #666666;",
            "type" => "textarea-large",
            "info" => "(利用している場合)テーブルキャプションは(通常)テーブルの最初の列になります.<br /><br />
			<strong>例:</strong><br /><code>&lt;table&gt;<br /><i>&lt;caption&gt;Results May 2008&lt;/caption&gt;</i><br />
			&lt;thead&gt;&lt;tr&gt;&lt;th&gt;Name&lt;/th&gt;&lt;th&gt;Address&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt;<br />
			&lt;tfoot&gt;&lt;tr&gt;&lt;td&gt;Previous&lt;/td&gt;&lt;td&gt;Next&lt;/td&gt;&lt;/tr&gt;&lt;/tfoot&gt;<br />
			&lt;tbody&gt;&lt;tr&gt;&lt;td&gt;John&lt;/td&gt;&lt;td&gt;Smallville&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;<br />
			&lt;/table&gt;</code><br /><br />
			<em>どのようにテーブルのフッター<code>tfoot</code>が本体<code>tbody</code>の<strong>前</strong>に来るのかに注意してください</em>"),

    array(    "name" => "テーブルのヘッダーセル",
    	    "category" => "tables",
            "id" => $shortname."_table_th",
            "std" => "background: #888888;\ncolor: #ffffff;\nfont-weight: bold;\nfont-size: 90%;\npadding: 4px 8px;\n
			border: solid 1px #ffffff;\ntext-align: left;",
            "type" => "textarea-large",
            "info" => "テーブルのヘッダーセルのスタイルを設定します <code>&lt;th&gt;</code> ... <code>&lt;/th&gt;</code>"),

    array(    "name" => "テーブルの本体のセル",
    	    "category" => "tables",
            "id" => $shortname."_table_td",
            "std" => "padding: 4px 8px;\nbackground-color: #ffffff;\nborder-bottom: 1px solid #dddddd;\ntext-align: left;",
            "type" => "textarea-large",
            "info" => "通常のテーブルのセルのスタイルを設定します <code>&lt;td&gt;</code> ... <code>&lt;/td&gt;</code>"),

    array(    "name" => "テーブルのフッターセル",
    	    "category" => "tables",
            "id" => $shortname."_table_tfoot_td",
            "std" => "",
            "type" => "textarea-large",
            "info" => "テーブルのフッターとなるセルのスタイルを個別に設定できます. 
        	<em>設定しない場合, テーブル本体のセルと同じスタイルになります.</em>"),
			
    array(    "name" => "一行おきの網掛けの適用先",
    	    "category" => "tables",
            "id" => $shortname."_table_zebra_stripes",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "一行おきの網掛けをテーブルに設定する際に, 同一投稿/ページ内の<strong>すべての</strong>テーブルを
			対象とするかどうかを設定します. \"No\"に設定し, 網掛けを適用したいテーブル毎に<code>zebra</code>クラス
			を追加することもできます.<br /><br />
			<strong>例:</strong><br /><code>&lt;table class=\"zebra\"&gt; ... &lt;/table&gt;</code>"),

    array(    "name" => "一行おきの網掛けスタイル",
    	    "category" => "tables",
            "id" => $shortname."_table_zebra_td",
            "std" => "background: #f4f4f4;",
            "type" => "textarea-large",
            "info" => "一行おきに網掛けがかかったストライプテーブルにしたい場合は, 一行おきに列に設定するセルのスタイルを
        		ここに設定します."),
			
    array(    "name" => "ポイント時のエフェクトの適用先",
    	    "category" => "tables",
            "id" => $shortname."_table_hover_rows",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "マウスがポイントした際のテーブルの列のスタイルを変更する際に, 同一投稿内の<strong>すべての</strong>
        		テーブルを対象とするかどうかを設定します. \"No\"に設定し, エフェクトを適用したいテーブル毎に<code>hover</code>
        		クラスを追加することもできます.<br /><br />
        		<strong>例:</strong><br />
				<code>&lt;table class=\"hover\"&gt; ... &lt;/table&gt;</code><br /><br />
				複数のクラスを追加することもできます. 
				例: 一行おきの網掛けとポイント時のエフェクトの両方を特定のテーブルに適用したい場合:<br /><br />
			<code>&lt;table class=\"zebra hover\"&gt; ... &lt;/table&gt;</code>"),

    array(    "name" => "ポイントされた列のスタイル",
    	    "category" => "tables",
            "id" => $shortname."_table_hover_td",
            "std" => "background: #e2e2e2;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "テーブルの列がポイントされた際のスタイルを設定する場合, ここにポイントされたテーブルのセルのスタイルを設定します."),

// New category: forms

    array(    "name" => "フォームフィールドのスタイル",
    	    "category" => "forms",
			"switch" => "yes",
            "id" => $shortname."_form_input_field_style",
            "std" => "color: #000000;\nborder-top: solid 1px #333333;\nborder-left: solid 1px #333333;\nborder-right: solid 1px #999999;\nborder-bottom: solid 1px #cccccc;",
            "type" => "textarea-large",
            "info" => "フォームの入力フィールドとテキストエリアのスタイルを設定します. "),

    array(    "name" => "フォームフィールドの背景イメージ",
    	    "category" => "forms",
           "id" => $shortname."_form_input_field_background",
            "std" => "inputbackgr.gif",
            "type" => "text", 
			"size" => "35", 
            "info" => "テキストフィールドとテキストエリア内部の\"影\"を設定します. 他に利用できる影には, <code>inputbackgr-red.gif</code>,
			<code>inputbackgr-green.gif</code>, <code>inputbackgr-blue.gif</code>があります. あるいは, 独自のイメージを<code>" .
            $css_img_path . "images/</code>にアップロードすることもできます. フォームの入力フィールドに背景を持たせない場合は, 
        	空欄にしておいてください."),
			
    array(    "name" => "フォームフィールドのハイライト",
    	    "category" => "forms",
            "id" => $shortname."_highlight_forms",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "フォームの入力フィールドがフォーカスを得た(誰かがフォーム内をクリックした)時に, ハイライトするかどうかを設定します"),

    array(    "name" => "ハイライトされたフォームフィールドのスタイル",
    	    "category" => "forms",
            "id" => $shortname."_highlight_forms_style",
            "std" => "background: #e8eff7;\nborder-color: #37699f;",
            "type" => "textarea-large",
            "info" => "上の設定で\"Yes\"を選択している場合に, 入力フィールドがハイライトされた状態のスタイルを設定します."),

    array(    "name" => "送信ボタンの通常時のスタイル",
    	    "category" => "forms",
            "id" => $shortname."_button_style",
            "std" => "background-color: #777777;\ncolor: #ffffff;\nborder: solid 2px #555555;\nfont-weight: bold;",
            "type" => "textarea-large",
            "info" => "送信ボタンが<strong>デフォルト</strong>状態にあるときのスタイルを設定します."),

    array(    "name" => "送信ボタンのポイント時のスタイル",
    	    "category" => "forms",
            "id" => $shortname."_button_style_hover",
            "std" => "background-color: #6b9c6b;\ncolor: #ffffff;\nborder: solid 2px #496d49;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "送信ボタンが<strong>ポイント</strong>状態にあるときのスタイルを設定します."),

// New category: blockquotes

    array(    "name" => "引用のスタイル",
    	    "category" => "blockquotes",
			"switch" => "yes",
            "id" => $shortname."_blockquote_style",
            "std" => "color: #555555;\npadding: 1em 1em;\nbackground: #f4f4f4;\nborder: solid 1px #e1e1e1;",
            "type" => "textarea-large",
            "info" => "<img src=\"" . $url_base . "/options/images/blockquotes.gif\" style=\"float: right; margin: 0 0 10px 10px;\">" . 
			"引用のスタイルを設定します. <br /><br />
			<strong>例:</strong><br /><code>font: italic 1.1em georgia, serif;<br />color: #336699;<br />
			padding: 0 1em;<br />background: #c9dbed;<br />border: dashed 5px #336699;</code><br /><br />
			例示されているスクリーンショットはIE7で取得したものです. IE以外のブラウザでは見え方が異なります."),
			
    array(    "name" => "引用内の引用のスタイル",
    	    "category" => "blockquotes",
            "id" => $shortname."_blockquote_style_2nd_level",
            "std" => "color: #444444;\npadding: 1em 1em;\nbackground: #e1e1e1;\nborder: solid 1px #d3d3d3;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "引用内の引用のスタイルを設定します."),

// New category: images

    array(    "name" => "投稿中のイメージ",
    	    "category" => "images",
			"switch" => "yes",
            "id" => $shortname."_post_image_style",
            "std" => "padding: 5px;\nborder: solid 1px #dddddd;\nbackground-color: #f3f3f3;\n-moz-border-radius: 3px;\n-khtml-border-radius: 3px;\n-webkit-border-radius: 3px;\nborder-radius: 3px;",
            "type" => "textarea-large",
            "info" => "キャプションが無い場合の, 投稿中のイメージのスタイルを設定します. \"radius\"を枠線に設定すると
			FirefoxやSafariで角が丸くなります. イメージの枠線を削除したい場合は, このボックス内のすべてを削除してください."),
			
    array(    "name" => "投稿中のイメージのキャプションスタイル",
    	    "category" => "images",
            "id" => $shortname."_post_image_caption_style",
            "std" => "border: 1px solid #dddddd;\ntext-align: center;\nbackground-color: #f3f3f3;\npadding-top: 4px;\nmargin: 10px 0 0 0;\n-moz-border-radius: 3px;\n-khtml-border-radius: 3px;\n-webkit-border-radius: 3px;\nborder-radius: 3px;",
            "type" => "textarea-large",
            "info" => "キャプションを持つ投稿内のイメージのキャプションボックスのスタイルを設定します.
        	\"radius\"を枠線に設定すると、FirefoxやSafariで角が丸くなります. イメージの枠線とキャプションとを削除したい場合は, 
        	このボックス内のすべてを削除してください."),

    array(    "name" => "キャプションテキストのスタイル",
    	    "category" => "images",
            "id" => $shortname."_image_caption_text",
            "std" => "font-size: 0.8em;\nline-height: 13px;\npadding: 2px 4px 5px;\nmargin: 0;\ncolor: #666666;",
            "type" => "textarea-large",
			"lastoption" => "yes", 
            "info" => "キャプションテキストのスタイルを設定します."),

// New category: html-inserts

    array(    "name" => "ヘッダーへのHTMLの挿入",
    	    "category" => "html-inserts",
			"switch" => "yes",
            "id" => $shortname."_html_inserts_header",
            "std" => "",
            "type" => "textarea-large",
			"editable" => "yes", 
            "info" => "Webサイトのヘッダーセクションに追加したいコード(JavaScript, HTML, CSS)をここで設定します. 
			コードが追加されるのは<code>&lt;head&gt;</code>と<code>&lt;/head&gt;</code>の間になります. 
			<strong>ノート:</strong> ここで追加されるHTMLタグは, テーブルやDIVコンテナのような\"目に見える\"HTMLタグ
			であってはなりません. もしここにHTMLを追加するのであれば, 次のような機械的に解析できるコードになるはずです:<br />
			<code>&lt;meta name=\"author\" content=\"John W. Doe\" /&gt;</code>."),

    array(    "name" => "BodyタグへのHTMLの挿入",
    	    "category" => "html-inserts",
            "id" => $shortname."_html_inserts_body_tag",
            "std" => "",
            "type" => "textarea-large",
			"editable" => "yes", 
            "info" => "Webサイトのbodyタグ<code>&lt;body&gt;</code>に追加したいコード(通常Javascript)をここで設定します. <br /><br />
			<strong>例:</strong><br /><code>onLoad=\"alert('The page is loading... now!')\"</code>と設定することで, 通常の
			<code>&lt;body&gt;</code>の代わりに<code>&lt;body <i>onLoad=\"alert('The page is loading... now!')\"</i>&gt;</code>という
			出力を得ることができます"),

    array(    "name" => "Bodyセクション先頭へのHTMLの挿入",
    	    "category" => "html-inserts",
            "id" => $shortname."_html_inserts_body_top",
            "std" => "",
            "type" => "textarea-large",
			"editable" => "yes", 
            "info" => "Webサイトのbodyセクションに追加したいコード(JavaScript, HTML, CSS)をここで設定します. 
				コードが追加されるのは<code>&lt;body&gt;</code>と<code>&lt;/body&gt;</code>の間で, <code>&lt;body&gt;</code>の直後になります."),

    array(    "name" => "Bodyセクション末尾へのHTMLの挿入",
    	    "category" => "html-inserts",
            "id" => $shortname."_html_inserts_body_bottom",
            "std" => "",
            "type" => "textarea-large",
			"editable" => "yes", 
            "info" => "Webサイトのbodyセクションに追加したいコード(JavaScript, HTML, CSS)をここで設定します. 
				コードが追加されるのは, <code>&lt;body&gt;</code>と<code>&lt;/body&gt;</code>の間で, <code>&lt;/body&gt;</code>の直前になります. 
				<strong>Google Analytics</strong>は通常ここに置かれますし, 他のトラッキングコードもおそらく同様でしょう."),

    array(    "name" => "CSSへの挿入",
    	    "category" => "html-inserts",
            "id" => $shortname."_html_inserts_css",
            "std" => "",
            "type" => "textarea-large",
			"editable" => "yes", 
			"lastoption" => "yes", 
            "info" => "あなたのテーマのCSSファイルに追加したいCSSのコードをここで設定します.<br /><br />
        		<strong>例</strong><br /><code>.newclass {<br />color: #123456;<br />border: solid 1px #000000;<br />
				font-family: arial, \"comic sans ms\", sans-serif;<br />background: url(". $css_img_path ."images/myimage.gif);
            	<br />}</code>"),

// New category: Archives page

    array(    "name" => "ページIDのアーカイブ",
    	    "category" => "archives-page",
			"switch" => "yes",
           "id" => $shortname."_archives_page_id",
            "std" => "",
            "type" => "text",
			"size" => "5",
            "info" => "Atahualpaはデフォルトではアーカイブページを持っていませんが, 独自に作成することができます:<ul>
				<li>ここに既存ページのIDを設定すると, そのページがアーカイブページとなります.</li>
				<li>そのページは, 空のページでもコンテンツがあるページでも構いません.</li>
				<li>ページにコンテンツがある場合, アーカイブページはその末尾に追加されます.</li></ul>
				アーカイブページは, (通常月単位の)アーカイブやカテゴリへのリンクをリストする\"ページ\"ページという意味で, 
				サイトマップに近いといえますが, \"ページ\"ページのリストは通常含まれていません. サイドバーのアーカイブリンクや
				の選択メニューとの違いは, リンクが通常のコンテンツと同じように中央カラムに表示されるという点にあります."),

    array(    "name" => "日付別のアーカイブの表示",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_date_show",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "日付別アーカイブを表示するかどうかを設定します"),
			
    array(    "name" => "日付別アーカイブのタイトル",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_date_title",
            "std" => __("Archives by Month","atahualpa"),
            "type" => "text",
            "info" => "年別 / 月別 / 日別 / 投稿別のアーカイブのヘッドラインを設定します."),

    array(    "name" => "日付別アーカイブのタイプ",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_date_type",
            "type" => "select",
            "std" => "monthly",
            "options" => array("yearly", "monthly", "weekly", "daily", "postbypost"),
            "info" => "日付ベースのアーカイブを年別 / 月別 / 週別 / 日別 / 投稿別のいずれで集計するかを設定します"),

    array(    "name" => "日付別アーカイブの制限",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_date_limit",
            "std" => "",
            "type" => "text",
            "info" => "オプション: ひづけべすのアーカイブリンク数の上限を設定します 上限を設けない場合は, 空欄にしておいてください. 
				<strong>例:</strong> <code>30</code>"),

    array(    "name" => "日付別アーカイブの件数表示",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_date_count",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "日付別のアーカイブリンクに件数を表示するかどうかを設定します. 
        		\"postbypost\"を上で選択している場合, ここの設定は意味を持ちません."),

    array(    "name" => "カテゴリ別アーカイブの表示",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_show",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "カテゴリ別アーカイブを設定するかどうかを設定します."),
			
    array(    "name" => "カテゴリ別アーカイブのタイトル",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_title",
            "std" => __("Archives by Category","atahualpa"),
            "type" => "text",
            "info" => "カテゴリ別アーカイブのヘッドライン"),

    array(    "name" => "カテゴリ別アーカイブの件数表示",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_count",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "各カテゴリリンクの後ろに投稿件数を表示するかどうかを設定します."),

    array(    "name" => "カテゴリ別アーカイブの深度",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_depth",
            "type" => "select",
            "std" => "0",
            "options" => array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"),
            "info" => "表示するカテゴリレベルの深度を制限します. すべてのカテゴリを表示する( = 深度制限を設けない)場合は, 0を選択してください."),

    array(    "name" => "カテゴリ別アーカイブの順序",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_orderby",
            "type" => "select",
            "std" => "name",
            "options" => array("ID", "name", "count"),
            "info" => "<ul><li><strong>ID</strong>と設定すると, カテゴリ別アーカイブリンクが時系列に並べ替えられます. </li>
				<li><strong>name</strong>と設定すると, アルファベット順に並べ替えられます</li>
				<li><strong>count</strong>と設定すると, 投稿数順に並べ替えられます</li></ul>"),

    array(    "name" => "カテゴリ別アーカイブのソート",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_order",
            "type" => "select",
            "std" => "ASC",
            "options" => array("ASC", "DESC"),
            "info" => "<ul><li><strong>ASC</strong>と設定すると, カテゴリリストが昇順に並べ替えられます</li>
			<li><strong>DESC</strong>と設定すると, カテゴリリストが降順に並べ替えられます</li></ul>"),	

    array(    "name" => "カテゴリ別アーカイブのフィードリンク",
    	    "category" => "archives-page",
           "id" => $shortname."_archives_category_feed",
            "type" => "select",
            "std" => "No",
            "options" => array("Yes", "No"),
			"lastoption" => "yes", 
            "info" => "各カテゴリのリンクの先に, 対応するリンクをもったRSSのアイコンを表示するかどうかを設定します."),
            
            
// New category: css-javascript

    array(    "name" => "CSSの外部ファイル/インラインの設定",
    	    "category" => "css-javascript",
			"switch" => "yes",
           "id" => $shortname."_css_external",
            "type" => "select",
            "std" => "Inline",
            "options" => array("External", "Inline"),
            "info" => "CSSコードを, 外部ファイルとするか, 各ページのヘッダにインラインで挿入するかを設定します. <br /><br /> 
				あなたの平均ページビューが1に近い場合は, インラインを選択したほうがいいでしょう. この場合, インラインCSSの方が
				外部CSSファイルよりも高速になるでしょう."),

    array(    "name" => "Javascriptの外部ファイル/インラインの設定",
    	    "category" => "css-javascript",
           "id" => $shortname."_javascript_external",
            "type" => "select",
            "std" => "Inline",
            "options" => array("External", "Inline"),
            "info" => "Javascriptを, 外部ファイルとするか, 各ページのヘッダにインラインで挿入するかを設定します. 
				注意点は上と同じです."),

    array(    "name" => "IE6のPNGのバグを修正するCSSセレクタの利用",
    	    "category" => "css-javascript",
           "id" => $shortname."_pngfix_selectors",
            "type" => "textarea-large",
            "std" => "a.posts-icon, a.comments-icon, a.email-icon, img.logo",
            "info" => "もしあなたが透過PNGイメージを利用しているのであれば, 透過PNGイメージを含むCSSセレクタをここ
			で設定することにより, それらのエレメントについてIE6の透過PNGのバグを修正することができます.
			セレクタはカンマで区切ってください. "),
			
    array(    "name" => "CSSの圧縮",
    	    "category" => "css-javascript",
           "id" => $shortname."_css_compress",
            "type" => "select",
            "std" => "Yes",
            "options" => array("Yes", "No"),
            "info" => "CSSの圧縮を選択すると, あなたのサーバでmod_deflateもしくはgzipが有効になっていれば, 追加ファイルサイズが7kbyte以下に収まるようになります.
			CSSのファイルサイズ: Atahualpaによる圧縮なし / Gzipなし : ～60-70 Kbyte. Atahualpaによる圧縮のみ : ～35 KByte
				Atahualpaによる圧縮 + Gzip/mod_deflate : ～7 KByte."),

    array(    "name" => "Allow debugging?",
    	    "category" => "css-javascript",
           "id" => $shortname."_allow_debug",
            "type" => "select",
            "std" => "Yes",
            "lastoption" => "yes",
            "options" => array("Yes", "No"),
            "info" => "ここを<strong>Yes</strong>に設定すると, ここまでの設定に依存せず, <code>?bfa_debug=1</code>がURLに追加<strong>された場合に</strong>,
			圧縮されていないCSS/JavascriptがインラインであなたのWebサイトのソースコードに表示されるようになります.
			更に, WordpressとAtahualpaのバージョンがメタタグに表示されるようになり, 検索エンジンに問題として認識されるコンテンツのダブりを
			回避するためにメタロボットタグに\"noindex,follow\"が追加されます. <br /><br />
			<strong>forum.bytesforall.comのような外部の誰かにサイトのコードを確認してもらう前に, ここを<code>YES</code>に設定してください.</strong>."),
			
/*                                
    array(    "name" => "Javascript: Compress?",
    	    "category" => "css-javascript",
           "id" => $shortname."_javascript_compress",
            "type" => "select",
            "std" => "Yes",
            	"lastoption" => "yes",
            "options" => array("Yes", "No"),
            "info" => "Turn this off whenever you want someone to look at the Javascript code of your site. The compressed Javascript will be almost 
            unreadable.<br /><br /><em>The compressed Javascript may not work properly if lines in the code, i.e. code 
            that you added, were not finished with a semicolon. If you experience weird Javascript related behavior, turn this option here off to see if it's 
            caused by the compression.</em>"),
*/

/* 
    array(    "name" => "Remove comment-reply.js?",
    	    "category" => "css-javascript",
           "id" => $shortname."_include_wp_comment_reply_js",
            "type" => "select",
            "std" => "No",
			"lastoption" => "yes", 
            "options" => array("Yes", "No"),
            "info" => "For WP 2.7+: Include WP's \"comment-reply.js\" in Atahualpa's js.php and remove it from the header? This will save 1 HTTP request to the web server."),
*/
                     
);

// Merge arrays to get different options sets for WP 2.7+ (with new paged comments settings) and WP 2.6 and older 
if (function_exists('wp_list_comments')) {
$options = array_merge($options1, $options2, $options3);  // WP 2.7 and newer
} else {
$options = array_merge($options1, $options3);  // WP 2.6 and older
}

?>